/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.circles.impetuses;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockEntityRedstoneImpetus
extends BlockEntityAbstractImpetus {
    public static final String TAG_STORED_PLAYER = "stored_player";
    public static final String TAG_STORED_PLAYER_PROFILE = "stored_player_profile";
    private GameProfile storedPlayerProfile = null;
    private UUID storedPlayer = null;
    private GameProfile cachedDisplayProfile = null;
    private ItemStack cachedDisplayStack = null;

    public BlockEntityRedstoneImpetus(BlockPos pWorldPosition, BlockState pBlockState) {
        super(HexBlockEntities.IMPETUS_REDSTONE_TILE, pWorldPosition, pBlockState);
    }

    @Nullable
    protected GameProfile getPlayerName() {
        ServerPlayer player;
        if (this.f_58857_ instanceof ServerLevel && (player = this.getStoredPlayer()) != null) {
            return player.m_36316_();
        }
        return this.storedPlayerProfile;
    }

    public void setPlayer(GameProfile profile, UUID player) {
        this.storedPlayerProfile = profile;
        this.storedPlayer = player;
        this.m_6596_();
    }

    public void clearPlayer() {
        this.storedPlayerProfile = null;
        this.storedPlayer = null;
    }

    public void updatePlayerProfile() {
        GameProfile newProfile;
        ServerPlayer player = this.getStoredPlayer();
        if (player != null && !(newProfile = player.m_36316_()).equals((Object)this.storedPlayerProfile)) {
            this.storedPlayerProfile = newProfile;
            this.m_6596_();
        }
    }

    @Nullable
    public ServerPlayer getStoredPlayer() {
        if (this.storedPlayer == null) {
            return null;
        }
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            HexAPI.LOGGER.error("Called getStoredPlayer on the client");
            return null;
        }
        ServerLevel slevel = (ServerLevel)level;
        Entity e = slevel.m_8791_(this.storedPlayer);
        if (e instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)e;
            return player;
        }
        if (e != null) {
            HexAPI.LOGGER.error("Entity {} stored in a cleric impetus wasn't a player somehow", (Object)e);
        }
        return null;
    }

    @Override
    public void applyScryingLensOverlay(List<Pair<ItemStack, Component>> lines, BlockState state, BlockPos pos, Player observer, Level world, Direction hitFace) {
        super.applyScryingLensOverlay(lines, state, pos, observer, world, hitFace);
        GameProfile name = this.getPlayerName();
        if (name != null) {
            if (!name.equals((Object)this.cachedDisplayProfile) || this.cachedDisplayStack == null) {
                this.cachedDisplayProfile = name;
                ItemStack head = new ItemStack((ItemLike)Items.f_42680_);
                NBTHelper.put(head, "SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)name));
                head.m_41720_().m_142312_(head.m_41784_());
                this.cachedDisplayStack = head;
            }
            lines.add((Pair<ItemStack, Component>)new Pair((Object)this.cachedDisplayStack, (Object)Component.m_237110_((String)"hexcasting.tooltip.lens.impetus.redstone.bound", (Object[])new Object[]{name.getName()})));
        } else {
            lines.add((Pair<ItemStack, Component>)new Pair((Object)new ItemStack((ItemLike)Items.f_42127_), (Object)Component.m_237115_((String)"hexcasting.tooltip.lens.impetus.redstone.bound.none")));
        }
    }

    @Override
    protected void saveModData(CompoundTag tag) {
        super.saveModData(tag);
        if (this.storedPlayer != null) {
            tag.m_128362_(TAG_STORED_PLAYER, this.storedPlayer);
        }
        if (this.storedPlayerProfile != null) {
            tag.m_128365_(TAG_STORED_PLAYER_PROFILE, (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.storedPlayerProfile));
        }
    }

    @Override
    protected void loadModData(CompoundTag tag) {
        super.loadModData(tag);
        this.storedPlayer = tag.m_128425_(TAG_STORED_PLAYER, 11) ? tag.m_128342_(TAG_STORED_PLAYER) : null;
        this.storedPlayerProfile = tag.m_128425_(TAG_STORED_PLAYER_PROFILE, 10) ? NbtUtils.m_129228_((CompoundTag)tag.m_128469_(TAG_STORED_PLAYER_PROFILE)) : null;
    }
}

