/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.item;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.client.ClientTickCounter;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public interface IotaHolderItem {
    public static final String TAG_OVERRIDE_VISUALLY = "VisualOverride";

    @Nullable
    public CompoundTag readIotaTag(ItemStack var1);

    @Nullable
    default public Iota readIota(ItemStack stack, ServerLevel world) {
        Item item = stack.m_41720_();
        if (!(item instanceof IotaHolderItem)) {
            throw new IllegalArgumentException("stack's item must be an IotaHolderItem but was " + stack.m_41720_());
        }
        IotaHolderItem dh = (IotaHolderItem)item;
        CompoundTag tag = dh.readIotaTag(stack);
        if (tag != null) {
            return IotaType.deserialize(tag, world);
        }
        return null;
    }

    @Nullable
    default public Iota emptyIota(ItemStack stack) {
        return null;
    }

    default public int getColor(ItemStack stack) {
        if (NBTHelper.hasString(stack, TAG_OVERRIDE_VISUALLY)) {
            IotaType iotaType;
            ResourceLocation key;
            String override = NBTHelper.getString(stack, TAG_OVERRIDE_VISUALLY);
            if (override != null && ResourceLocation.m_135830_((String)override) && HexIotaTypes.REGISTRY.m_7804_(key = new ResourceLocation(override)) && (iotaType = (IotaType)HexIotaTypes.REGISTRY.m_7745_(key)) != null) {
                return iotaType.color();
            }
            return 0xFF000000 | Mth.m_14169_((float)(ClientTickCounter.getTotal() * 2.0f % 360.0f / 360.0f), (float)0.75f, (float)1.0f);
        }
        CompoundTag tag = this.readIotaTag(stack);
        if (tag == null) {
            return -524040;
        }
        return IotaType.getColor(tag);
    }

    public boolean writeable(ItemStack var1);

    public boolean canWrite(ItemStack var1, @Nullable Iota var2);

    public void writeDatum(ItemStack var1, @Nullable Iota var2);

    public static void appendHoverText(IotaHolderItem self, ItemStack stack, List<Component> components, TooltipFlag flag) {
        CompoundTag datumTag = self.readIotaTag(stack);
        if (datumTag != null) {
            Component cmp = IotaType.getDisplay(datumTag);
            components.add((Component)Component.m_237110_((String)"hexcasting.spelldata.onitem", (Object[])new Object[]{cmp}));
            if (flag.m_7050_()) {
                components.add((Component)Component.m_237113_((String)"").m_7220_(NbtUtils.m_178061_((Tag)datumTag)));
            }
        } else if (NBTHelper.hasString(stack, TAG_OVERRIDE_VISUALLY)) {
            components.add((Component)Component.m_237110_((String)"hexcasting.spelldata.onitem", (Object[])new Object[]{Component.m_237115_((String)"hexcasting.spelldata.anything").m_130940_(ChatFormatting.LIGHT_PURPLE)}));
        }
    }
}

