/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.mishaps;

import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.iota.GarbageIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lat/petrak/hexcasting/api/casting/mishaps/MishapInvalidIota;", "Lat/petrak/hexcasting/api/casting/mishaps/Mishap;", "perpetrator", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "reverseIdx", "", "expected", "Lnet/minecraft/network/chat/Component;", "(Lat/petrak/hexcasting/api/casting/iota/Iota;ILnet/minecraft/network/chat/Component;)V", "getExpected", "()Lnet/minecraft/network/chat/Component;", "getPerpetrator", "()Lat/petrak/hexcasting/api/casting/iota/Iota;", "getReverseIdx", "()I", "accentColor", "Lat/petrak/hexcasting/api/pigment/FrozenPigment;", "ctx", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "errorCtx", "Lat/petrak/hexcasting/api/casting/mishaps/Mishap$Context;", "errorMessage", "execute", "", "env", "stack", "", "Companion", "hexcasting-forge-1.20.1"})
public final class MishapInvalidIota
extends Mishap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Iota perpetrator;
    private final int reverseIdx;
    @NotNull
    private final Component expected;

    public MishapInvalidIota(@NotNull Iota perpetrator, int reverseIdx, @NotNull Component expected) {
        Intrinsics.checkNotNullParameter((Object)perpetrator, (String)"perpetrator");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        this.perpetrator = perpetrator;
        this.reverseIdx = reverseIdx;
        this.expected = expected;
    }

    @NotNull
    public final Iota getPerpetrator() {
        return this.perpetrator;
    }

    public final int getReverseIdx() {
        return this.reverseIdx;
    }

    @NotNull
    public final Component getExpected() {
        return this.expected;
    }

    @Override
    @NotNull
    public FrozenPigment accentColor(@NotNull CastingEnvironment ctx, @NotNull Mishap.Context errorCtx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
        return this.dyeColor(DyeColor.GRAY);
    }

    @Override
    public void execute(@NotNull CastingEnvironment env, @NotNull Mishap.Context errorCtx, @NotNull List<Iota> stack) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        stack.set(stack.size() - 1 - this.reverseIdx, new GarbageIota());
    }

    @Override
    @Nullable
    protected Component errorMessage(@NotNull CastingEnvironment ctx, @NotNull Mishap.Context errorCtx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
        ResourceLocation perpKey = HexIotaTypes.REGISTRY.m_7981_(this.perpetrator.getType());
        ResourceLocation resourceLocation = perpKey;
        MutableComponent perpDesc = Component.m_264568_((String)("hexcasting.iota." + perpKey + ".desc"), (String)("hexcasting.mishap.invalid_value.class." + (resourceLocation != null ? resourceLocation.m_135815_() : null)));
        Object[] objectArray = new Object[4];
        objectArray[0] = this.expected;
        objectArray[1] = this.reverseIdx;
        Intrinsics.checkNotNullExpressionValue((Object)perpDesc, (String)"perpDesc");
        objectArray[2] = perpDesc;
        Intrinsics.checkNotNullExpressionValue((Object)this.perpetrator.display(), (String)"perpetrator.display()");
        return this.error("invalid_value", objectArray);
    }

    @JvmStatic
    @NotNull
    public static final MishapInvalidIota ofType(@NotNull Iota perpetrator, int reverseIdx, @NotNull String name) {
        return Companion.ofType(perpetrator, reverseIdx, name);
    }

    @JvmStatic
    @NotNull
    public static final MishapInvalidIota of(@NotNull Iota perpetrator, int reverseIdx, @NotNull String name, Object ... translations) {
        return Companion.of(perpetrator, reverseIdx, name, translations);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\f\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000f"}, d2={"Lat/petrak/hexcasting/api/casting/mishaps/MishapInvalidIota$Companion;", "", "()V", "of", "Lat/petrak/hexcasting/api/casting/mishaps/MishapInvalidIota;", "perpetrator", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "reverseIdx", "", "name", "", "translations", "", "(Lat/petrak/hexcasting/api/casting/iota/Iota;ILjava/lang/String;[Ljava/lang/Object;)Lat/petrak/hexcasting/api/casting/mishaps/MishapInvalidIota;", "ofType", "hexcasting-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MishapInvalidIota ofType(@NotNull Iota perpetrator, int reverseIdx, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)perpetrator, (String)"perpetrator");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.of(perpetrator, reverseIdx, "class." + name, new Object[0]);
        }

        @JvmStatic
        @NotNull
        public final MishapInvalidIota of(@NotNull Iota perpetrator, int reverseIdx, @NotNull String name, Object ... translations) {
            Intrinsics.checkNotNullParameter((Object)perpetrator, (String)"perpetrator");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)translations, (String)"translations");
            String key = "hexcasting.mishap.invalid_value." + name;
            return new MishapInvalidIota(perpetrator, reverseIdx, (Component)HexUtils.asTranslatedComponent(key, Arrays.copyOf(translations, translations.length)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

