/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.mishaps;

import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.common.lib.HexDamageTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lat/petrak/hexcasting/api/casting/mishaps/MishapBadBrainsweep;", "Lat/petrak/hexcasting/api/casting/mishaps/Mishap;", "mob", "Lnet/minecraft/world/entity/Mob;", "pos", "Lnet/minecraft/core/BlockPos;", "(Lnet/minecraft/world/entity/Mob;Lnet/minecraft/core/BlockPos;)V", "getMob", "()Lnet/minecraft/world/entity/Mob;", "getPos", "()Lnet/minecraft/core/BlockPos;", "accentColor", "Lat/petrak/hexcasting/api/pigment/FrozenPigment;", "ctx", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "errorCtx", "Lat/petrak/hexcasting/api/casting/mishaps/Mishap$Context;", "errorMessage", "Lnet/minecraft/network/chat/Component;", "execute", "", "stack", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "particleSpray", "Lat/petrak/hexcasting/api/casting/ParticleSpray;", "hexcasting-forge-1.20.1"})
public final class MishapBadBrainsweep
extends Mishap {
    @NotNull
    private final Mob mob;
    @NotNull
    private final BlockPos pos;

    public MishapBadBrainsweep(@NotNull Mob mob, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.mob = mob;
        this.pos = pos;
    }

    @NotNull
    public final Mob getMob() {
        return this.mob;
    }

    @NotNull
    public final BlockPos getPos() {
        return this.pos;
    }

    @Override
    @NotNull
    public FrozenPigment accentColor(@NotNull CastingEnvironment ctx, @NotNull Mishap.Context errorCtx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
        return this.dyeColor(DyeColor.GREEN);
    }

    @Override
    public void execute(@NotNull CastingEnvironment ctx, @NotNull Mishap.Context errorCtx, @NotNull List<Iota> stack) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        LivingEntity livingEntity = (LivingEntity)this.mob;
        DamageSource damageSource = this.mob.m_269291_().m_269298_(HexDamageTypes.OVERCAST, (Entity)ctx.getCastingEntity());
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"mob.damageSources().sour\u2026RCAST, ctx.castingEntity)");
        Mishap.Companion.trulyHurt(livingEntity, damageSource, 1.0f);
    }

    @Override
    @NotNull
    public ParticleSpray particleSpray(@NotNull CastingEnvironment ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Vec3 vec3 = Vec3.m_82512_((Vec3i)((Vec3i)this.pos));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(pos)");
        return ParticleSpray.Companion.burst$default(ParticleSpray.Companion, vec3, 1.0, 0, 4, null);
    }

    @Override
    @NotNull
    protected Component errorMessage(@NotNull CastingEnvironment ctx, @NotNull Mishap.Context errorCtx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
        Object[] objectArray = new Object[]{this.blockAtPos(ctx, this.pos)};
        return this.error("bad_brainsweep", objectArray);
    }
}

