/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.pos;

import com.seibel.distanthorizons.coreapi.util.MathUtil;
import java.util.Objects;

public class Pos2D {
    public static final Pos2D ZERO = new Pos2D(0, 0);
    private final int x;
    private final int y;

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Pos2D(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Pos2D add(Pos2D other) {
        return new Pos2D(this.x + other.x, this.y + other.y);
    }

    public Pos2D subtract(Pos2D other) {
        return new Pos2D(this.x - other.x, this.y - other.y);
    }

    public Pos2D subtract(int value) {
        return new Pos2D(this.x - value, this.y - value);
    }

    public double dist(Pos2D other) {
        return Math.sqrt(Math.pow(this.x - other.x, 2.0) + Math.pow(this.y - other.y, 2.0));
    }

    public long distSquared(Pos2D other) {
        return MathUtil.pow2((long)this.x - (long)other.x) + MathUtil.pow2((long)this.y - (long)other.y);
    }

    public int chebyshevDist(Pos2D other) {
        return Math.max(Math.abs(this.x - other.x), Math.abs(this.y - other.y));
    }

    public int manhattanDist(Pos2D other) {
        return Math.abs(this.x - other.x) + Math.abs(this.y - other.y);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + "]";
    }

    public boolean equals(Object otherObj) {
        if (otherObj == this) {
            return true;
        }
        if (otherObj instanceof Pos2D) {
            Pos2D otherPos = (Pos2D)otherObj;
            return this.x == otherPos.x && this.y == otherPos.y;
        }
        return false;
    }
}

