/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.logging;

import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpamReducedLogger {
    private static final Logger LOGGER = LogManager.getLogger((String)MethodHandles.lookup().lookupClass().getSimpleName());
    public static final List<WeakReference<SpamReducedLogger>> loggers = Collections.synchronizedList(new LinkedList());
    private final int maxLogCount;
    private final AtomicInteger logTries = new AtomicInteger(0);

    public static synchronized void flushAll() {
        loggers.removeIf(logger -> logger.get() == null);
        loggers.forEach(logger -> {
            SpamReducedLogger l = (SpamReducedLogger)logger.get();
            if (l != null) {
                l.reset();
            }
        });
    }

    public SpamReducedLogger(int maxLogPerSec) {
        this.maxLogCount = maxLogPerSec;
        loggers.add(new WeakReference<SpamReducedLogger>(this));
    }

    private static boolean isLessSpecificThan(Level _this, Level other) {
        return _this.intLevel() >= other.intLevel();
    }

    public void reset() {
        this.logTries.set(0);
    }

    public boolean canMaybeLog() {
        return this.logTries.get() < this.maxLogCount;
    }

    public void log(Level level, String str, Object ... param) {
        if (this.logTries.get() >= this.maxLogCount) {
            return;
        }
        LOGGER.log(SpamReducedLogger.isLessSpecificThan(level, Level.INFO) ? Level.INFO : level, str, param);
    }

    public void error(String str, Object ... param) {
        this.log(Level.ERROR, str, param);
    }

    public void warn(String str, Object ... param) {
        this.log(Level.WARN, str, param);
    }

    public void info(String str, Object ... param) {
        this.log(Level.INFO, str, param);
    }

    public void debug(String str, Object ... param) {
        this.log(Level.DEBUG, str, param);
    }

    public void trace(String str, Object ... param) {
        this.log(Level.TRACE, str, param);
    }

    public void incLogTries() {
        this.logTries.getAndIncrement();
    }

    public void logInc(Level level, String str, Object ... param) {
        if (this.logTries.getAndIncrement() >= this.maxLogCount) {
            return;
        }
        LOGGER.log(SpamReducedLogger.isLessSpecificThan(level, Level.INFO) ? Level.INFO : level, str, param);
    }

    public void errorInc(String str, Object ... param) {
        this.logInc(Level.ERROR, str, param);
    }

    public void warnInc(String str, Object ... param) {
        this.logInc(Level.WARN, str, param);
    }

    public void infoInc(String str, Object ... param) {
        this.logInc(Level.INFO, str, param);
    }

    public void debugInc(String str, Object ... param) {
        this.logInc(Level.DEBUG, str, param);
    }

    public void traceInc(String str, Object ... param) {
        this.logInc(Level.TRACE, str, param);
    }
}

