/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding;

import com.seibel.distanthorizons.api.enums.config.EDhApiGrassSideRendering;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiBlockMaterial;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiDebugRendering;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.BufferMergeDirectionEnum;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.BufferQuad;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBuffer;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.coreapi.util.MathUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.MemoryUtil;

public class LodQuadBuilder {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private final ArrayList<BufferQuad>[] opaqueQuads = new ArrayList[6];
    private final ArrayList<BufferQuad>[] transparentQuads = new ArrayList[6];
    private final boolean doTransparency;
    private final IClientLevelWrapper clientLevelWrapper;
    private final EDhApiDebugRendering debugRenderingMode;
    private final EDhApiGrassSideRendering grassSideRenderingMode;
    public static final int[][][] DIRECTION_VERTEX_IBO_QUAD = new int[][][]{new int[][]{{1, 0}, {1, 1}, {0, 1}, {0, 0}}, new int[][]{{0, 0}, {0, 1}, {1, 1}, {1, 0}}, new int[][]{{0, 0}, {0, 1}, {1, 1}, {1, 0}}, new int[][]{{1, 0}, {1, 1}, {0, 1}, {0, 0}}, new int[][]{{0, 0}, {1, 0}, {1, 1}, {0, 1}}, new int[][]{{0, 1}, {1, 1}, {1, 0}, {0, 0}}};
    private int premergeCount = 0;

    public LodQuadBuilder(boolean doTransparency, IClientLevelWrapper clientLevelWrapper) {
        this.doTransparency = doTransparency;
        for (int i = 0; i < 6; ++i) {
            this.opaqueQuads[i] = new ArrayList();
            this.transparentQuads[i] = new ArrayList();
        }
        this.clientLevelWrapper = clientLevelWrapper;
        this.debugRenderingMode = Config.Client.Advanced.Debugging.debugRendering.get();
        this.grassSideRenderingMode = Config.Client.Advanced.Graphics.Quality.grassSideRendering.get();
    }

    public void addQuadAdj(EDhDirection dir, short x, short y, short z, short widthEastWest, short widthNorthSouthOrUpDown, int color, byte irisBlockMaterialId, byte skyLight, byte blockLight) {
        ArrayList<BufferQuad> quadList;
        if (dir == EDhDirection.DOWN) {
            throw new IllegalArgumentException("addQuadAdj() is only for adj direction! Not UP or Down!");
        }
        BufferQuad quad = new BufferQuad(x, y, z, widthEastWest, widthNorthSouthOrUpDown, color, irisBlockMaterialId, skyLight, blockLight, dir);
        ArrayList<BufferQuad> arrayList = quadList = this.doTransparency && ColorUtil.getAlpha(color) < 255 ? this.transparentQuads[dir.ordinal()] : this.opaqueQuads[dir.ordinal()];
        if (!quadList.isEmpty() && (quadList.get(quadList.size() - 1).tryMerge(quad, BufferMergeDirectionEnum.EastWest) || quadList.get(quadList.size() - 1).tryMerge(quad, BufferMergeDirectionEnum.NorthSouthOrUpDown))) {
            ++this.premergeCount;
            return;
        }
        quadList.add(quad);
    }

    public void addQuadUp(short minX, short maxY, short minZ, short widthEastWest, short widthNorthSouthOrUpDown, int color, byte irisBlockMaterialId, byte skylight, byte blocklight) {
        BufferQuad quad = new BufferQuad(minX, maxY, minZ, widthEastWest, widthNorthSouthOrUpDown, color, irisBlockMaterialId, skylight, blocklight, EDhDirection.UP);
        boolean isTransparent = this.doTransparency && ColorUtil.getAlpha(color) < 255;
        ArrayList<BufferQuad> quadList = isTransparent ? this.transparentQuads[EDhDirection.UP.ordinal()] : this.opaqueQuads[EDhDirection.UP.ordinal()];
        quadList.add(quad);
    }

    public void addQuadDown(short x, short y, short z, short width, short wz, int color, byte irisBlockMaterialId, byte skylight, byte blocklight) {
        BufferQuad quad = new BufferQuad(x, y, z, width, wz, color, irisBlockMaterialId, skylight, blocklight, EDhDirection.DOWN);
        ArrayList<BufferQuad> qs = this.doTransparency && ColorUtil.getAlpha(color) < 255 ? this.transparentQuads[EDhDirection.DOWN.ordinal()] : this.opaqueQuads[EDhDirection.DOWN.ordinal()];
        qs.add(quad);
    }

    public void mergeQuads() {
        long mergeCount = 0L;
        long preQuadsCount = this.getCurrentOpaqueQuadsCount() + this.getCurrentTransparentQuadsCount();
        if (preQuadsCount <= 1L) {
            return;
        }
        for (int directionIndex = 0; directionIndex < 6; ++directionIndex) {
            mergeCount += LodQuadBuilder.mergeQuadsInternal(this.opaqueQuads, directionIndex, BufferMergeDirectionEnum.EastWest);
            if (this.doTransparency) {
                mergeCount += LodQuadBuilder.mergeQuadsInternal(this.transparentQuads, directionIndex, BufferMergeDirectionEnum.EastWest);
            }
            if (directionIndex != EDhDirection.UP.ordinal() && directionIndex != EDhDirection.DOWN.ordinal()) continue;
            mergeCount += LodQuadBuilder.mergeQuadsInternal(this.opaqueQuads, directionIndex, BufferMergeDirectionEnum.NorthSouthOrUpDown);
            if (!this.doTransparency) continue;
            mergeCount += LodQuadBuilder.mergeQuadsInternal(this.transparentQuads, directionIndex, BufferMergeDirectionEnum.NorthSouthOrUpDown);
        }
    }

    private static long mergeQuadsInternal(ArrayList<BufferQuad>[] list, int directionIndex, BufferMergeDirectionEnum mergeDirection) {
        if (list[directionIndex].size() <= 1) {
            return 0L;
        }
        list[directionIndex].sort((objOne, objTwo) -> objOne.compare((BufferQuad)objTwo, mergeDirection));
        long mergeCount = 0L;
        ListIterator<BufferQuad> iter = list[directionIndex].listIterator();
        BufferQuad currentQuad = iter.next();
        while (iter.hasNext()) {
            BufferQuad nextQuad = iter.next();
            if (currentQuad.tryMerge(nextQuad, mergeDirection)) {
                ++mergeCount;
                iter.set(null);
                continue;
            }
            currentQuad = nextQuad;
        }
        list[directionIndex].removeIf(Objects::isNull);
        return mergeCount;
    }

    public ArrayList<ByteBuffer> makeOpaqueVertexBuffers() {
        return this.makeVertexBuffers(this.opaqueQuads);
    }

    public ArrayList<ByteBuffer> makeTransparentVertexBuffers() {
        return this.makeVertexBuffers(this.transparentQuads);
    }

    private ArrayList<ByteBuffer> makeVertexBuffers(ArrayList<BufferQuad>[] quadList) {
        ArrayList<ByteBuffer> byteBufferList = new ArrayList<ByteBuffer>(3);
        ByteBuffer buffer = null;
        for (int directionIndex = 0; directionIndex < 6; ++directionIndex) {
            if (quadList[directionIndex].isEmpty()) continue;
            for (int quadIndex = 0; quadIndex < quadList[directionIndex].size(); ++quadIndex) {
                if (buffer == null || !buffer.hasRemaining()) {
                    buffer = MemoryUtil.memAlloc((int)ColumnRenderBuffer.FULL_SIZED_BUFFER);
                    byteBufferList.add(buffer);
                }
                this.putQuad(buffer, quadList[directionIndex].get(quadIndex));
            }
        }
        for (int i = 0; i < byteBufferList.size(); ++i) {
            buffer = byteBufferList.get(i);
            buffer.limit(buffer.position());
            buffer.rewind();
        }
        return byteBufferList;
    }

    private void putQuad(ByteBuffer bb, BufferQuad quad) {
        int[][] quadBase = DIRECTION_VERTEX_IBO_QUAD[quad.direction.ordinal()];
        short widthEastWest = quad.widthEastWest;
        short widthNorthSouth = quad.widthNorthSouthOrUpDown;
        byte normalIndex = (byte)quad.direction.ordinal();
        EDhDirection.Axis axis = quad.direction.getAxis();
        for (int i = 0; i < quadBase.length; ++i) {
            int mz;
            int my;
            int mx;
            short dz;
            short dy;
            short dx;
            switch (axis) {
                case X: {
                    dx = 0;
                    dy = quadBase[i][1] == 1 ? widthNorthSouth : (short)0;
                    dz = quadBase[i][0] == 1 ? widthEastWest : (short)0;
                    mx = 0;
                    my = quadBase[i][1] == 1 ? 1 : -1;
                    mz = quadBase[i][0] == 1 ? 1 : -1;
                    break;
                }
                case Y: {
                    dx = quadBase[i][0] == 1 ? widthEastWest : (short)0;
                    dy = 0;
                    dz = quadBase[i][1] == 1 ? widthNorthSouth : (short)0;
                    mx = quadBase[i][0] == 1 ? 1 : -1;
                    my = 0;
                    mz = quadBase[i][1] == 1 ? 1 : -1;
                    break;
                }
                case Z: {
                    dx = quadBase[i][0] == 1 ? widthEastWest : (short)0;
                    dy = quadBase[i][1] == 1 ? widthNorthSouth : (short)0;
                    dz = 0;
                    mx = quadBase[i][0] == 1 ? 1 : -1;
                    my = quadBase[i][1] == 1 ? 1 : -1;
                    mz = 0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Axis enum: " + axis);
                }
            }
            int color = quad.color;
            if (quad.irisBlockMaterialId == EDhApiBlockMaterial.GRASS.index && this.debugRenderingMode == EDhApiDebugRendering.OFF && this.grassSideRenderingMode != EDhApiGrassSideRendering.AS_GRASS && (quad.direction.getAxis().isHorizontal() || quad.direction == EDhDirection.DOWN) && (this.grassSideRenderingMode == EDhApiGrassSideRendering.AS_DIRT || this.grassSideRenderingMode == EDhApiGrassSideRendering.FADE_TO_DIRT && quadBase[i][1] == 0 || quad.direction == EDhDirection.DOWN)) {
                color = this.clientLevelWrapper.getDirtBlockColor();
                color = ColorUtil.applyShade(color, MC.getShade(quad.direction));
            }
            this.putVertex(bb, (short)(quad.x + dx), (short)(quad.y + dy), (short)(quad.z + dz), quad.hasError ? ColorUtil.RED : color, quad.hasError ? (byte)0 : normalIndex, quad.hasError ? (byte)0 : quad.irisBlockMaterialId, quad.hasError ? (byte)15 : (byte)quad.skyLight, quad.hasError ? (byte)15 : (byte)quad.blockLight, mx, my, mz);
        }
    }

    private void putVertex(ByteBuffer bb, short x, short y, short z, int color, byte normalIndex, byte irisBlockMaterialId, byte skylight, byte blocklight, int mx, int my, int mz) {
        skylight = (byte)(skylight % 16);
        blocklight = (byte)(blocklight % 16);
        bb.putShort(x);
        bb.putShort(y);
        bb.putShort(z);
        short meta = 0;
        meta = (short)(meta | (skylight | blocklight << 4));
        int mirco = 0;
        if (mx != 0) {
            mirco = (byte)(mirco | (mx > 0 ? 1 : 3));
        }
        if (my != 0) {
            mirco = (byte)(mirco | (my > 0 ? 4 : 12));
        }
        if (mz != 0) {
            mirco = (byte)(mirco | (mz > 0 ? 16 : 48));
        }
        meta = (short)(meta | mirco << 8);
        bb.putShort(meta);
        byte r = (byte)ColorUtil.getRed(color);
        byte g = (byte)ColorUtil.getGreen(color);
        byte b = (byte)ColorUtil.getBlue(color);
        byte a = this.doTransparency ? (byte)ColorUtil.getAlpha(color) : (byte)-1;
        bb.put(r);
        bb.put(g);
        bb.put(b);
        bb.put(a);
        bb.put(irisBlockMaterialId);
        bb.put(normalIndex);
        bb.putShort((short)0);
    }

    public int getCurrentOpaqueQuadsCount() {
        int i = 0;
        for (ArrayList<BufferQuad> quadList : this.opaqueQuads) {
            i += quadList.size();
        }
        return i;
    }

    public int getCurrentTransparentQuadsCount() {
        if (!this.doTransparency) {
            return 0;
        }
        int i = 0;
        for (ArrayList<BufferQuad> quadList : this.transparentQuads) {
            i += quadList.size();
        }
        return i;
    }

    public int getCurrentNeededOpaqueVertexBufferCount() {
        return MathUtil.ceilDiv(this.getCurrentOpaqueQuadsCount(), ColumnRenderBuffer.MAX_QUADS_PER_BUFFER);
    }

    public int getCurrentNeededTransparentVertexBufferCount() {
        if (!this.doTransparency) {
            return 0;
        }
        return MathUtil.ceilDiv(this.getCurrentTransparentQuadsCount(), ColumnRenderBuffer.MAX_QUADS_PER_BUFFER);
    }
}

