/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import snownee.jade.api.callback.JadeItemModNameCallback;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;

public class ModIdentification
implements ResourceManagerReloadListener {
    public static final ModIdentification INSTANCE = new ModIdentification();
    private static final Map<String, Optional<String>> NAMES = Maps.newConcurrentMap();

    public static void invalidateCache() {
        NAMES.clear();
    }

    public static Optional<String> getModName(String namespace) {
        return NAMES.computeIfAbsent(namespace, $ -> {
            Optional<String> optional = ClientProxy.getModName($);
            if (optional.isPresent()) {
                return optional;
            }
            String key = "jade.modName." + $;
            if (I18n.m_118936_((String)key)) {
                return Optional.of(I18n.m_118938_((String)key, (Object[])new Object[0]));
            }
            return Optional.empty();
        });
    }

    public static String getModName(ResourceLocation id) {
        return ModIdentification.getModName(id.m_135827_()).orElse(id.m_135827_());
    }

    public static String getModName(Block block) {
        return ModIdentification.getModName(CommonProxy.getId(block));
    }

    public static String getModName(ItemStack stack) {
        for (JadeItemModNameCallback callback : WailaClientRegistration.INSTANCE.itemModNameCallback.callbacks()) {
            String s = callback.gatherItemModName(stack);
            if (Strings.isNullOrEmpty((String)s)) continue;
            return s;
        }
        String id = CommonProxy.getModIdFromItem(stack);
        return ModIdentification.getModName(id).orElse(id);
    }

    public static String getModName(Entity entity) {
        if (entity instanceof Painting) {
            PaintingVariant motive = (PaintingVariant)((Painting)entity).m_28554_().m_203334_();
            return ModIdentification.getModName(CommonProxy.getId(motive));
        }
        if (entity instanceof ItemEntity) {
            return ModIdentification.getModName(((ItemEntity)entity).m_32055_());
        }
        if (entity instanceof FallingBlockEntity) {
            return ModIdentification.getModName(((FallingBlockEntity)entity).m_31980_().m_60734_());
        }
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            return ModIdentification.getModName(BuiltInRegistries.f_256735_.m_7981_((Object)villager.m_7141_().m_35571_()));
        }
        return ModIdentification.getModName(CommonProxy.getId(entity.m_6095_()));
    }

    public void m_6213_(ResourceManager manager) {
        ModIdentification.invalidateCache();
    }
}

