/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.inputs.IJeiGuiEventListener;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.util.MathUtil;
import mezz.jei.library.gui.recipes.RecipeLayout;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.Rect2i;

public class RecipeLayoutInputHandler<T>
implements IJeiInputHandler {
    private final RecipeLayout<T> recipeLayout;
    private final List<IJeiInputHandler> inputHandlers;
    private final List<IJeiGuiEventListener> guiEventListeners;

    public RecipeLayoutInputHandler(RecipeLayout<T> recipeLayout) {
        this.recipeLayout = recipeLayout;
        this.inputHandlers = new ArrayList<IJeiInputHandler>();
        this.guiEventListeners = new ArrayList<IJeiGuiEventListener>();
    }

    @Override
    public ScreenRectangle getArea() {
        Rect2i area = this.recipeLayout.getRect();
        return new ScreenRectangle(area.m_110085_(), area.m_110086_(), area.m_110090_(), area.m_110091_());
    }

    @Override
    public boolean handleInput(double mouseX, double mouseY, IJeiUserInput userInput) {
        double relativeMouseY;
        ScreenPosition position;
        double relativeMouseX;
        ScreenRectangle widgetArea;
        if (!this.recipeLayout.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        Rect2i area = this.recipeLayout.getRect();
        double recipeMouseX = mouseX - (double)area.m_110085_();
        double recipeMouseY = mouseY - (double)area.m_110086_();
        for (IJeiInputHandler inputHandler : this.inputHandlers) {
            widgetArea = inputHandler.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY) || !inputHandler.handleInput(relativeMouseX = recipeMouseX - (double)(position = widgetArea.f_263846_()).f_263719_(), relativeMouseY = recipeMouseY - (double)position.f_263694_(), userInput)) continue;
            return true;
        }
        for (IJeiGuiEventListener guiEventListener : this.guiEventListeners) {
            widgetArea = guiEventListener.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY) || !RecipeLayoutInputHandler.handleInput(guiEventListener, relativeMouseX = recipeMouseX - (double)(position = widgetArea.f_263846_()).f_263719_(), relativeMouseY = recipeMouseY - (double)position.f_263694_(), userInput)) continue;
            return true;
        }
        if (userInput.isSimulate()) {
            return true;
        }
        IRecipeCategory<T> recipeCategory = this.recipeLayout.getRecipeCategory();
        T recipe = this.recipeLayout.getRecipe();
        boolean legacyResult = recipeCategory.handleInput(recipe, recipeMouseX, recipeMouseY, userInput.getKey());
        return legacyResult;
    }

    private static boolean handleInput(IJeiGuiEventListener guiEventListener, double relativeMouseX, double relativeMouseY, IJeiUserInput userInput) {
        InputConstants.Key key = userInput.getKey();
        switch (key.m_84868_()) {
            case MOUSE: {
                if (userInput.isSimulate()) {
                    return guiEventListener.mouseClicked(relativeMouseX, relativeMouseY, key.m_84873_());
                }
                return guiEventListener.mouseReleased(relativeMouseX, relativeMouseY, key.m_84873_());
            }
            case KEYSYM: {
                if (userInput.isSimulate()) break;
                return guiEventListener.keyPressed(relativeMouseX, relativeMouseY, key.m_84873_(), 0, userInput.getModifiers());
            }
            default: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean handleMouseDragged(double mouseX, double mouseY, InputConstants.Key mouseKey, double dragX, double dragY) {
        double relativeMouseY;
        ScreenPosition position;
        double relativeMouseX;
        ScreenRectangle widgetArea;
        if (!this.recipeLayout.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        Rect2i area = this.recipeLayout.getRect();
        double recipeMouseX = mouseX - (double)area.m_110085_();
        double recipeMouseY = mouseY - (double)area.m_110086_();
        for (IJeiInputHandler inputHandler : this.inputHandlers) {
            widgetArea = inputHandler.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY) || !inputHandler.handleMouseDragged(relativeMouseX = recipeMouseX - (double)(position = widgetArea.f_263846_()).f_263719_(), relativeMouseY = recipeMouseY - (double)position.f_263694_(), mouseKey, dragX, dragY)) continue;
            return true;
        }
        for (IJeiGuiEventListener guiEventListener : this.guiEventListeners) {
            widgetArea = guiEventListener.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY) || !guiEventListener.mouseDragged(relativeMouseX = recipeMouseX - (double)(position = widgetArea.f_263846_()).f_263719_(), relativeMouseY = recipeMouseY - (double)position.f_263694_(), mouseKey.m_84873_(), dragX, dragY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        double relativeMouseY;
        ScreenPosition position;
        double relativeMouseX;
        ScreenRectangle widgetArea;
        if (!this.recipeLayout.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        Rect2i area = this.recipeLayout.getRect();
        double recipeMouseX = mouseX - (double)area.m_110085_();
        double recipeMouseY = mouseY - (double)area.m_110086_();
        for (IJeiInputHandler inputHandler : this.inputHandlers) {
            widgetArea = inputHandler.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY) || !inputHandler.handleMouseScrolled(relativeMouseX = recipeMouseX - (double)(position = widgetArea.f_263846_()).f_263719_(), relativeMouseY = recipeMouseY - (double)position.f_263694_(), scrollDelta)) continue;
            return true;
        }
        for (IJeiGuiEventListener guiEventListener : this.guiEventListeners) {
            widgetArea = guiEventListener.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY) || !guiEventListener.mouseScrolled(relativeMouseX = recipeMouseX - (double)(position = widgetArea.f_263846_()).f_263719_(), relativeMouseY = recipeMouseY - (double)position.f_263694_(), scrollDelta)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleMouseMoved(double mouseX, double mouseY) {
        double relativeMouseY;
        double relativeMouseX;
        ScreenPosition position;
        ScreenRectangle widgetArea;
        if (!this.recipeLayout.isMouseOver(mouseX, mouseY)) {
            return;
        }
        Rect2i area = this.recipeLayout.getRect();
        double recipeMouseX = mouseX - (double)area.m_110085_();
        double recipeMouseY = mouseY - (double)area.m_110086_();
        for (IJeiInputHandler inputHandler : this.inputHandlers) {
            widgetArea = inputHandler.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY)) continue;
            position = widgetArea.f_263846_();
            relativeMouseX = recipeMouseX - (double)position.f_263719_();
            relativeMouseY = recipeMouseY - (double)position.f_263694_();
            inputHandler.handleMouseMoved(relativeMouseX, relativeMouseY);
        }
        for (IJeiGuiEventListener guiEventListener : this.guiEventListeners) {
            widgetArea = guiEventListener.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY)) continue;
            position = widgetArea.f_263846_();
            relativeMouseX = recipeMouseX - (double)position.f_263719_();
            relativeMouseY = recipeMouseY - (double)position.f_263694_();
            guiEventListener.mouseMoved(relativeMouseX, relativeMouseY);
        }
    }

    public void addInputHandler(IJeiInputHandler inputHandler) {
        this.inputHandlers.add(inputHandler);
    }

    public void addGuiEventListener(IJeiGuiEventListener guiEventListener) {
        this.guiEventListeners.add(guiEventListener);
    }
}

