/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.bookmarks.RecipeBookmark;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public class RecipeBookmarkButton
extends GuiIconToggleButton {
    private final BookmarkList bookmarks;
    @Nullable
    private final RecipeBookmark<?, ?> recipeBookmark;
    private boolean bookmarked;

    public static RecipeBookmarkButton create(IRecipeLayoutDrawable<?> recipeLayout, IIngredientManager ingredientManager, BookmarkList bookmarks) {
        RecipeBookmark<?, ?> recipeBookmark = RecipeBookmark.create(recipeLayout, ingredientManager);
        Textures textures = Internal.getTextures();
        IDrawable icon = textures.getRecipeBookmark();
        Rect2i area = recipeLayout.getRecipeBookmarkButtonArea();
        Rect2i layoutArea = recipeLayout.getRect();
        area.m_173047_(area.m_110085_() + layoutArea.m_110085_());
        area.m_173054_(area.m_110086_() + layoutArea.m_110086_());
        RecipeBookmarkButton recipeBookmarkButton = new RecipeBookmarkButton(icon, bookmarks, recipeBookmark);
        recipeBookmarkButton.updateBounds(area);
        return recipeBookmarkButton;
    }

    private RecipeBookmarkButton(IDrawable icon, BookmarkList bookmarks, @Nullable RecipeBookmark<?, ?> recipeBookmark) {
        super(icon, icon);
        this.bookmarks = bookmarks;
        this.recipeBookmark = recipeBookmark;
        if (recipeBookmark == null) {
            this.button.f_93623_ = false;
            this.button.f_93624_ = false;
        }
        this.tick();
    }

    @Override
    protected void getTooltips(JeiTooltip tooltip) {
        if (this.recipeBookmark != null) {
            if (this.bookmarks.contains(this.recipeBookmark)) {
                tooltip.add((FormattedText)Component.m_237115_((String)"jei.tooltip.bookmarks.recipe.remove"));
            } else {
                tooltip.add((FormattedText)Component.m_237115_((String)"jei.tooltip.bookmarks.recipe.add"));
            }
        }
    }

    @Override
    public void tick() {
        this.bookmarked = this.recipeBookmark != null && this.bookmarks.contains(this.recipeBookmark);
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.bookmarked;
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (this.recipeBookmark != null) {
            if (!input.isSimulate()) {
                this.bookmarks.toggleBookmark(this.recipeBookmark);
            }
            return true;
        }
        return false;
    }

    @Override
    public void draw(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.draw(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.bookmarked) {
            guiGraphics.m_285944_(RenderType.m_285907_(), this.button.m_252754_(), this.button.m_252907_(), this.button.m_252754_() + this.button.m_5711_(), this.button.m_252907_() + this.button.m_93694_(), 0x1100FF00);
        }
    }

    public boolean isBookmarked() {
        return this.bookmarked;
    }
}

