/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client.particle;

import ganymedes01.etfuturum.client.particle.BeeNectarFX;
import ganymedes01.etfuturum.client.particle.BiomeFX;
import ganymedes01.etfuturum.client.particle.BlackHeartFX;
import ganymedes01.etfuturum.client.particle.CherryLeafFX;
import ganymedes01.etfuturum.client.particle.CopperGlowFX;
import ganymedes01.etfuturum.client.particle.CustomDripFX;
import ganymedes01.etfuturum.client.particle.EndRodFX;
import ganymedes01.etfuturum.client.particle.FallingDustFX;
import ganymedes01.etfuturum.client.particle.InnerBlockParticleFX;
import ganymedes01.etfuturum.client.particle.SoulFlameFX;
import ganymedes01.etfuturum.core.utils.RandomXoshiro256StarStar;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class CustomParticles {
    protected static Random rand = new RandomXoshiro256StarStar();

    public static EntityFX spawnInvisibleBlockParticle(World world, double x, double y, double z) {
        InnerBlockParticleFX particle = new InnerBlockParticleFX(world, x, y, z);
        return CustomParticles.spawnParticle(world, particle);
    }

    public static EntityFX spawnCopperWaxOnParticle(World world, double x, double y, double z) {
        CopperGlowFX particle = new CopperGlowFX(world, x, y, z, -23764);
        return CustomParticles.spawnParticle(world, particle);
    }

    public static EntityFX spawnCopperWaxOffParticle(World world, double x, double y, double z) {
        CopperGlowFX particle = new CopperGlowFX(world, x, y, z, -1);
        return CustomParticles.spawnParticle(world, particle);
    }

    public static EntityFX spawnCopperScrapeParticle(World world, double x, double y, double z) {
        CopperGlowFX particle = new CopperGlowFX(world, x, y, z, -8856895);
        return CustomParticles.spawnParticle(world, particle);
    }

    public static EntityFX spawnBlackHeartParticle(World world, double x, double y, double z) {
        BlackHeartFX particle = new BlackHeartFX(world, x, y, z);
        return CustomParticles.spawnParticle(world, particle);
    }

    public static EntityFX spawnEndRodParticle(World world, double x, double y, double z) {
        EndRodFX particle = new EndRodFX(world, x, y, z);
        return CustomParticles.spawnParticle(world, particle);
    }

    public static EntityFX spawnFallingDustParticle(World world, double x, double y, double z, int color) {
        FallingDustFX particle = new FallingDustFX(world, x, y, z, color);
        return CustomParticles.spawnParticle(world, particle);
    }

    public static EntityFX spawnDrippingParticle(World world, double x, double y, double z, int color) {
        return CustomParticles.spawnDrippingParticleWithSound(world, x, y, z, null, color, false);
    }

    public static EntityFX spawnDrippingParticle(World world, double x, double y, double z, int color, boolean splashes) {
        return CustomParticles.spawnDrippingParticleWithSound(world, x, y, z, null, color, splashes);
    }

    public static EntityFX spawnDrippingParticleWithSound(World world, double x, double y, double z, String sound, int color) {
        return CustomParticles.spawnDrippingParticleWithSound(world, x, y, z, sound, color, false);
    }

    public static EntityFX spawnDrippingParticleWithSound(World world, double x, double y, double z, String sound, int color, boolean splashes) {
        CustomDripFX particle = new CustomDripFX(world, x, y, z, sound, color, splashes);
        return CustomParticles.spawnParticle(world, particle);
    }

    public static EntityFX spawnBeeNectarParticle(World world, double x, double y, double z) {
        BeeNectarFX particle = new BeeNectarFX(world, x, y, z);
        return CustomParticles.spawnParticle(world, particle);
    }

    public static EntityFX spawnCrimsonSpore(World world, double x, double y, double z) {
        double d0 = (double)rand.nextFloat() * 0.5 * (double)rand.nextFloat() * 0.1 * 5.0;
        BiomeFX particle = new BiomeFX(world, x, y, z, rand.nextGaussian() * 0.05, d0, rand.nextGaussian() * 0.05, 0.02f);
        particle.func_70538_b(0.9f, 0.4f, 0.5f);
        return CustomParticles.spawnParticle(world, (EntityFX)particle);
    }

    public static EntityFX spawnWarpedSpore(World world, double x, double y, double z) {
        double d0 = (double)rand.nextFloat() * 0.5 * (double)rand.nextFloat() * 0.1 * 5.0;
        BiomeFX particle = new BiomeFX(world, x, y, z, rand.nextGaussian() * 0.05, d0, rand.nextGaussian() * 0.05, 0.001f);
        particle.func_70538_b(0.1f, 0.1f, 0.3f);
        return CustomParticles.spawnParticle(world, (EntityFX)particle);
    }

    public static EntityFX spawnAshParticle(World world, double x, double y, double z) {
        double d0 = (double)rand.nextFloat() * -1.9 * (double)rand.nextFloat() * 0.1;
        double d1 = (double)rand.nextFloat() * -0.5 * (double)rand.nextFloat() * 0.1 * 5.0;
        double d2 = (double)rand.nextFloat() * -1.9 * (double)rand.nextFloat() * 0.1;
        BiomeFX particle = new BiomeFX(world, x, y, z, d0, d1, d2, (float)MathHelper.func_82716_a((Random)rand, (double)0.001, (double)0.02));
        particle.func_70538_b(0.7294118f, 0.69411767f, 0.7607843f);
        return CustomParticles.spawnParticle(world, (EntityFX)particle);
    }

    public static EntityFX spawnCherryLeaf(World world, double x, double y, double z) {
        CherryLeafFX particle = new CherryLeafFX(world, x, y, z);
        return CustomParticles.spawnParticle(world, particle);
    }

    public static EntityFX spawnSoulFlame(World world, double x, double y, double z, double mX, double mY, double mZ) {
        SoulFlameFX particle = new SoulFlameFX(world, x, y, z, mX, mY, mZ);
        return CustomParticles.spawnParticle(world, particle);
    }

    public static EntityFX spawnSoulFlame(World world, double x, double y, double z) {
        SoulFlameFX particle = new SoulFlameFX(world, x, y, z);
        return CustomParticles.spawnParticle(world, particle);
    }

    protected static EntityFX spawnParticle(World world, EntityFX entityFX) {
        if (world.field_72995_K) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(entityFX);
            return entityFX;
        }
        return null;
    }
}

