/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen;

import com.hbm.world.gen.MapGenBaseMeta;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;

public class MapGenChainloader
extends MapGenBase {
    private MapGenBase parent;
    private List<MapGenBase> generators = new ArrayList<MapGenBase>();
    private static List<MapGenBase> overworldGenerators = new ArrayList<MapGenBase>();
    private static List<MapGenBase> netherGenerators = new ArrayList<MapGenBase>();
    private static byte[] blockMetas;

    public void func_151539_a(IChunkProvider chunk, World world, int chunkX, int chunkZ, Block[] blocks) {
        this.parent.func_151539_a(chunk, world, chunkX, chunkZ, blocks);
        if (world.field_73011_w.field_76574_g != 0 && world.field_73011_w.field_76574_g != -1) {
            return;
        }
        for (MapGenBase generator : this.generators) {
            if (generator instanceof MapGenBaseMeta) {
                ((MapGenBaseMeta)generator).setMetas(blockMetas);
            }
            generator.func_151539_a(chunk, world, chunkX, chunkZ, blocks);
        }
    }

    public static void register() {
        MapGenEventHandler handler = new MapGenEventHandler();
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)handler);
        MinecraftForge.EVENT_BUS.register((Object)handler);
    }

    public static void addOverworldGenerator(MapGenBase generator) {
        if (overworldGenerators.contains(generator)) {
            return;
        }
        overworldGenerators.add(generator);
    }

    public static void addNetherGenerator(MapGenBase generator) {
        if (netherGenerators.contains(generator)) {
            return;
        }
        netherGenerators.add(generator);
    }

    static /* synthetic */ byte[] access$402(byte[] x0) {
        blockMetas = x0;
        return x0;
    }

    public static class MapGenEventHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void addMapGenChainloader(InitMapGenEvent event) {
            if (!(event.newGen instanceof MapGenChainloader)) {
                if (event.type == InitMapGenEvent.EventType.CAVE) {
                    MapGenChainloader loader = new MapGenChainloader();
                    loader.parent = event.newGen;
                    loader.generators = overworldGenerators;
                    event.newGen = loader;
                } else if (event.type == InitMapGenEvent.EventType.NETHER_CAVE) {
                    MapGenChainloader loader = new MapGenChainloader();
                    loader.parent = event.newGen;
                    loader.generators = netherGenerators;
                    event.newGen = loader;
                }
            }
        }

        @SubscribeEvent
        public void storeLatestBlockMeta(ChunkProviderEvent.ReplaceBiomeBlocks event) {
            MapGenChainloader.access$402(event.metaArray);
        }
    }
}

