/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

public class BufferUtil {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    public static void writeString(ByteBuf buf, String value) {
        if (value == null) {
            buf.writeInt(-1);
            return;
        }
        byte[] bytes = value.getBytes(CHARSET);
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
    }

    public static String readString(ByteBuf buf) {
        int count = buf.readInt();
        if (count < 0) {
            return null;
        }
        byte[] bytes = new byte[count];
        buf.readBytes(bytes);
        return new String(bytes, CHARSET);
    }

    public static void writeIntArray(ByteBuf buf, int[] array) {
        buf.writeInt(array.length);
        for (int value : array) {
            buf.writeInt(value);
        }
    }

    public static int[] readIntArray(ByteBuf buf) {
        int length = buf.readInt();
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = buf.readInt();
        }
        return array;
    }

    public static void writeVec3(ByteBuf buf, Vec3 vector) {
        buf.writeBoolean(vector != null);
        if (vector == null) {
            return;
        }
        buf.writeDouble(vector.field_72450_a);
        buf.writeDouble(vector.field_72448_b);
        buf.writeDouble(vector.field_72449_c);
    }

    public static Vec3 readVec3(ByteBuf buf) {
        boolean vectorExists = buf.readBoolean();
        if (!vectorExists) {
            return null;
        }
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    public static void writeNBT(ByteBuf buf, NBTTagCompound compound) {
        if (compound != null) {
            byte[] nbtData = new byte[]{};
            try {
                nbtData = CompressedStreamTools.func_74798_a((NBTTagCompound)compound);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            buf.writeShort((int)((short)nbtData.length));
            buf.writeBytes(nbtData);
        } else {
            buf.writeShort(-1);
        }
    }

    public static NBTTagCompound readNBT(ByteBuf buf) {
        short nbtLength = buf.readShort();
        if (nbtLength == -1) {
            return new NBTTagCompound();
        }
        byte[] tags = new byte[nbtLength];
        buf.readBytes(tags);
        try {
            return CompressedStreamTools.func_152457_a((byte[])tags, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (IOException e) {
            e.printStackTrace();
            return new NBTTagCompound();
        }
    }

    public static void writeItemStack(ByteBuf buf, ItemStack item) {
        if (item == null) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(Item.func_150891_b((Item)item.func_77973_b()));
            buf.writeByte(item.field_77994_a);
            buf.writeShort(item.func_77960_j());
            NBTTagCompound nbtTagCompound = null;
            if (item.func_77973_b().func_77645_m() || item.func_77973_b().func_77651_p()) {
                nbtTagCompound = item.field_77990_d;
            }
            BufferUtil.writeNBT(buf, nbtTagCompound);
        }
    }

    public static ItemStack readItemStack(ByteBuf buf) {
        ItemStack item = null;
        short id = buf.readShort();
        if (id >= 0) {
            byte quantity = buf.readByte();
            short meta = buf.readShort();
            item = new ItemStack(Item.func_150899_d((int)id), (int)quantity, (int)meta);
            item.field_77990_d = BufferUtil.readNBT(buf);
        }
        return item;
    }
}

