/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.uninos;

import api.hbm.tile.ILoadedTile;
import com.hbm.uninos.GenNode;
import com.hbm.uninos.UniNodespace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;

public abstract class NodeNet<R, P, L extends GenNode> {
    public static Random rand = new Random();
    public boolean valid = true;
    public Set<L> links = new LinkedHashSet<L>();
    public HashMap<R, Long> receiverEntries = new HashMap();
    public HashMap<P, Long> providerEntries = new HashMap();

    public NodeNet() {
        UniNodespace.activeNodeNets.add(this);
    }

    public boolean isSubscribed(R receiver) {
        return this.receiverEntries.containsKey(receiver);
    }

    public void addReceiver(R receiver) {
        this.receiverEntries.put(receiver, System.currentTimeMillis());
    }

    public void removeReceiver(R receiver) {
        this.receiverEntries.remove(receiver);
    }

    public boolean isProvider(P provider) {
        return this.providerEntries.containsKey(provider);
    }

    public void addProvider(P provider) {
        this.providerEntries.put(provider, System.currentTimeMillis());
    }

    public void removeProvider(P provider) {
        this.providerEntries.remove(provider);
    }

    public void joinNetworks(NodeNet network) {
        if (network == this) {
            return;
        }
        ArrayList<L> oldNodes = new ArrayList<L>(network.links.size());
        oldNodes.addAll(network.links);
        for (GenNode conductor : oldNodes) {
            this.forceJoinLink(conductor);
        }
        network.links.clear();
        for (Object connector : network.receiverEntries.keySet()) {
            this.addReceiver(connector);
        }
        for (Object connector : network.providerEntries.keySet()) {
            this.addProvider(connector);
        }
        network.destroy();
    }

    public NodeNet joinLink(L node) {
        if (((GenNode)node).net != null) {
            ((NodeNet)((GenNode)node).net).leaveLink(node);
        }
        return this.forceJoinLink(node);
    }

    public NodeNet forceJoinLink(L node) {
        this.links.add(node);
        ((GenNode)node).setNet((NodeNet)this);
        return this;
    }

    public void leaveLink(L node) {
        ((GenNode)node).setNet(null);
        this.links.remove(node);
    }

    public void invalidate() {
        this.valid = false;
        UniNodespace.activeNodeNets.remove(this);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void resetTrackers() {
    }

    public abstract void update();

    public void destroy() {
        this.invalidate();
        for (GenNode link : this.links) {
            if (link.net != this) continue;
            link.setNet(null);
        }
        this.links.clear();
        this.receiverEntries.clear();
        this.providerEntries.clear();
    }

    public static boolean isBadLink(Object o) {
        if (o instanceof ILoadedTile && !((ILoadedTile)o).isLoaded()) {
            return true;
        }
        return o instanceof TileEntity && ((TileEntity)o).func_145837_r();
    }
}

