/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.recipes.FractionRecipes;
import com.hbm.lib.Library;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityMachineFractionTower
extends TileEntityLoadedBase
implements IBufPacketReceiver,
IFluidStandardTransceiver,
IFluidCopiable {
    public FluidTank[] tanks = new FluidTank[3];
    AxisAlignedBB bb = null;

    public TileEntityMachineFractionTower() {
        this.tanks[0] = new FluidTank(Fluids.HEAVYOIL, 4000);
        this.tanks[1] = new FluidTank(Fluids.BITUMEN, 4000);
        this.tanks[2] = new FluidTank(Fluids.SMEAR, 4000);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntity stack = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e);
            if (stack instanceof TileEntityMachineFractionTower) {
                TileEntityMachineFractionTower frac = (TileEntityMachineFractionTower)stack;
                for (int i = 0; i < 3; ++i) {
                    frac.tanks[i].setTankType(this.tanks[i].getTankType());
                }
                int oil = Math.min(this.tanks[0].getFill(), frac.tanks[0].getMaxFill() - frac.tanks[0].getFill());
                int left = Math.min(frac.tanks[1].getFill(), this.tanks[1].getMaxFill() - this.tanks[1].getFill());
                int right = Math.min(frac.tanks[2].getFill(), this.tanks[2].getMaxFill() - this.tanks[2].getFill());
                this.tanks[0].setFill(this.tanks[0].getFill() - oil);
                this.tanks[1].setFill(this.tanks[1].getFill() + left);
                this.tanks[2].setFill(this.tanks[2].getFill() + right);
                frac.tanks[0].setFill(frac.tanks[0].getFill() + oil);
                frac.tanks[1].setFill(frac.tanks[1].getFill() - left);
                frac.tanks[2].setFill(frac.tanks[2].getFill() - right);
            }
            this.setupTanks();
            this.updateConnections();
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.fractionate();
            }
            this.sendFluid();
            this.networkPackNT(50);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].deserialize(buf);
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    private void sendFluid() {
        for (DirPos pos : this.getConPos()) {
            this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.sendFluid(this.tanks[2], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    private DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    private void setupTanks() {
        Tuple.Pair<FluidStack, FluidStack> quart = FractionRecipes.getFractions(this.tanks[0].getTankType());
        if (quart != null) {
            this.tanks[1].setTankType(quart.getKey().type);
            this.tanks[2].setTankType(quart.getValue().type);
        } else {
            this.tanks[0].setTankType(Fluids.NONE);
            this.tanks[1].setTankType(Fluids.NONE);
            this.tanks[2].setTankType(Fluids.NONE);
        }
    }

    private void fractionate() {
        Tuple.Pair<FluidStack, FluidStack> quart = FractionRecipes.getFractions(this.tanks[0].getTankType());
        if (quart != null) {
            int left = quart.getKey().fill;
            int right = quart.getValue().fill;
            if (this.tanks[0].getFill() >= 100 && this.hasSpace(left, right)) {
                this.tanks[0].setFill(this.tanks[0].getFill() - 100);
                this.tanks[1].setFill(this.tanks[1].getFill() + left);
                this.tanks[2].setFill(this.tanks[2].getFill() + right);
            }
        }
    }

    private boolean hasSpace(int left, int right) {
        return this.tanks[1].getFill() + left <= this.tanks[1].getMaxFill() && this.tanks[2].getFill() + right <= this.tanks[2].getMaxFill();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].readFromNBT(nbt, "tank" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].writeToNBT(nbt, "tank" + i);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1], this.tanks[2]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }
}

