/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityShrapnel;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerWatz;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Heatable;
import com.hbm.inventory.gui.GUIWatz;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemWatzPellet;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Compat;
import com.hbm.util.EnumUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.function.Function;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWatz
extends TileEntityMachineBase
implements IFluidStandardTransceiver,
IControlReceiver,
IGUIProvider,
IFluidCopiable {
    public FluidTank[] tanks;
    public FluidTank[] sharedTanks;
    public int heat;
    public double fluxLastBase;
    public double fluxLastReaction;
    public double fluxDisplay;
    public boolean isOn;
    public boolean isLocked = false;
    public ItemStack[] locks = new ItemStack[this.slots.length];
    AxisAlignedBB bb = null;

    public TileEntityWatz() {
        super(24);
        this.tanks = new FluidTank[3];
        this.tanks[0] = new FluidTank(Fluids.COOLANT, 64000);
        this.tanks[1] = new FluidTank(Fluids.COOLANT_HOT, 64000);
        this.tanks[2] = new FluidTank(Fluids.WATZ, 64000);
        this.resetSharedTanks();
    }

    @Override
    public String getName() {
        return "container.watz";
    }

    protected void resetSharedTanks() {
        this.sharedTanks = new FluidTank[3];
        this.sharedTanks[0] = new FluidTank(Fluids.COOLANT, 64000);
        this.sharedTanks[1] = new FluidTank(Fluids.COOLANT_HOT, 64000);
        this.sharedTanks[2] = new FluidTank(Fluids.WATZ, 64000);
        this.sharedTanks[0].setFill(this.tanks[0].getFill());
        this.sharedTanks[1].setFill(this.tanks[1].getFill());
        this.sharedTanks[2].setFill(this.tanks[2].getFill());
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.resetSharedTanks();
        }
        if (!this.field_145850_b.field_72995_K && !this.updateLock()) {
            int i;
            TileEntityWatz segment2;
            TileEntity tile;
            boolean turnedOn = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e) == ModBlocks.watz_pump && this.field_145850_b.func_72878_l(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e, 0) > 0;
            ArrayList<TileEntityWatz> segments = new ArrayList<TileEntityWatz>();
            segments.add(this);
            this.subscribeToTop();
            for (int y = this.field_145848_d - 3; y >= 0 && (tile = Compat.getTileStandard(this.field_145850_b, this.field_145851_c, y, this.field_145849_e)) instanceof TileEntityWatz; y -= 3) {
                segments.add((TileEntityWatz)tile);
            }
            FluidTank[] sharedTanks = new FluidTank[3];
            for (int i2 = 0; i2 < 3; ++i2) {
                sharedTanks[i2] = new FluidTank(this.tanks[i2].getTankType(), 0);
            }
            for (TileEntityWatz segment2 : segments) {
                segment2.setupCoolant();
                for (int i3 = 0; i3 < 3; ++i3) {
                    sharedTanks[i3].changeTankSize(sharedTanks[i3].getMaxFill() + segment2.tanks[i3].getMaxFill());
                    sharedTanks[i3].setFill(sharedTanks[i3].getFill() + segment2.tanks[i3].getFill());
                }
            }
            for (i = segments.size() - 1; i >= 0; --i) {
                segment2 = (TileEntityWatz)segments.get(i);
                segment2.updateCoolant(sharedTanks);
            }
            this.updateReaction(null, sharedTanks, turnedOn);
            for (i = 1; i < segments.size(); ++i) {
                segment2 = (TileEntityWatz)segments.get(i);
                TileEntityWatz above = (TileEntityWatz)segments.get(i - 1);
                segment2.updateReaction(above, sharedTanks, turnedOn);
            }
            for (TileEntityWatz segment2 : segments) {
                segment2.sharedTanks[0] = sharedTanks[0];
                segment2.sharedTanks[1] = sharedTanks[1];
                segment2.sharedTanks[2] = sharedTanks[2];
                segment2.isOn = turnedOn;
                segment2.networkPackNT(25);
                segment2.heat = (int)((double)segment2.heat * 0.99);
            }
            for (int i4 = segments.size() - 1; i4 >= 0; --i4) {
                segment2 = (TileEntityWatz)segments.get(i4);
                for (int j = 0; j < 3; ++j) {
                    int min = Math.min(segment2.tanks[j].getMaxFill(), sharedTanks[j].getFill());
                    sharedTanks[j].setFill(sharedTanks[j].getFill() - min);
                    segment2.tanks[j].setFill(min);
                }
            }
            ((TileEntityWatz)segments.get(segments.size() - 1)).sendOutBottom();
            if (sharedTanks[2].getFill() > 0) {
                for (int x = -3; x <= 3; ++x) {
                    for (int y = 3; y < 6; ++y) {
                        for (int z = -3; z <= 3; ++z) {
                            this.field_145850_b.func_147449_b(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z, Blocks.field_150350_a);
                        }
                    }
                }
                this.disassemble();
                ChunkRadiationManager.proxy.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, 1000.0f);
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 2), (double)this.field_145849_e + 0.5, "hbm:block.rbmk_explosion", 50.0f, 1.0f);
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "rbmkmush");
                data.func_74776_a("scale", 5.0f);
                PacketDispatcher.wrapper.sendToAllAround(new AuxParticlePacketNT(data, (double)this.field_145851_c + 0.5, this.field_145848_d + 2, (double)this.field_145849_e + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 250.0));
                MainRegistry.proxy.effectNT(data);
                return;
            }
        }
    }

    public void setupCoolant() {
        this.tanks[0].setTankType(Fluids.COOLANT);
        this.tanks[1].setTankType(this.tanks[0].getTankType().getTrait(FT_Heatable.class).getFirstStep().typeProduced);
    }

    public void updateCoolant(FluidTank[] tanks) {
        double coolingFactor = 0.2;
        double heatToUse = (double)this.heat * coolingFactor;
        FT_Heatable trait = tanks[0].getTankType().getTrait(FT_Heatable.class);
        FT_Heatable.HeatingStep step = trait.getFirstStep();
        int heatCycles = (int)(heatToUse / (double)step.heatReq);
        int coolCycles = tanks[0].getFill() / step.amountReq;
        int hotCycles = (tanks[1].getMaxFill() - tanks[1].getFill()) / step.amountProduced;
        int cycles = Math.min(heatCycles, Math.min(hotCycles, coolCycles));
        this.heat -= cycles * step.heatReq;
        tanks[0].setFill(tanks[0].getFill() - cycles * step.amountReq);
        tanks[1].setFill(tanks[1].getFill() + cycles * step.amountProduced);
    }

    public void updateReaction(TileEntityWatz above, FluidTank[] tanks, boolean turnedOn) {
        int i;
        if (turnedOn) {
            ItemWatzPellet.EnumWatzType type;
            ArrayList<ItemStack> pellets = new ArrayList<ItemStack>();
            for (int i2 = 0; i2 < 24; ++i2) {
                ItemStack stack = this.slots[i2];
                if (stack == null || stack.func_77973_b() != ModItems.watz_pellet) continue;
                pellets.add(stack);
            }
            double baseFlux = 0.0;
            for (ItemStack stack : pellets) {
                ItemWatzPellet.EnumWatzType type2 = (ItemWatzPellet.EnumWatzType)((Object)EnumUtil.grabEnumSafely(ItemWatzPellet.EnumWatzType.class, stack.func_77960_j()));
                baseFlux += type2.passive;
            }
            double inputFlux = baseFlux + this.fluxLastReaction;
            double addedFlux = 0.0;
            double addedHeat = 0.0;
            for (ItemStack stack : pellets) {
                type = (ItemWatzPellet.EnumWatzType)((Object)EnumUtil.grabEnumSafely(ItemWatzPellet.EnumWatzType.class, stack.func_77960_j()));
                Function burnFunc = type.burnFunc;
                Function heatDiv = type.heatDiv;
                if (burnFunc == null) continue;
                double div = heatDiv != null ? heatDiv.effonix(this.heat) : 1.0;
                double burn = burnFunc.effonix(inputFlux) / div;
                ItemWatzPellet.setYield(stack, ItemWatzPellet.getYield(stack) - burn);
                addedFlux += burn;
                addedHeat += type.heatEmission * burn;
                tanks[2].setFill(tanks[2].getFill() + (int)Math.round(type.mudContent * burn));
            }
            for (ItemStack stack : pellets) {
                type = (ItemWatzPellet.EnumWatzType)((Object)EnumUtil.grabEnumSafely(ItemWatzPellet.EnumWatzType.class, stack.func_77960_j()));
                Function absorbFunc = type.absorbFunc;
                if (absorbFunc == null) continue;
                double absorb = absorbFunc.effonix(baseFlux + this.fluxLastReaction);
                addedHeat += absorb;
                ItemWatzPellet.setYield(stack, ItemWatzPellet.getYield(stack) - absorb);
                tanks[2].setFill(tanks[2].getFill() + (int)Math.round(type.mudContent * absorb));
            }
            this.heat = (int)((double)this.heat + addedHeat);
            this.fluxLastBase = baseFlux;
            this.fluxLastReaction = addedFlux;
        } else {
            this.fluxLastBase = 0.0;
            this.fluxLastReaction = 0.0;
        }
        for (i = 0; i < 24; ++i) {
            ItemStack stack = this.slots[i];
            if (stack == null || stack.func_77973_b() != ModItems.watz_pellet || !(ItemWatzPellet.getEnrichment(stack) <= 0.0)) continue;
            this.slots[i] = new ItemStack(ModItems.watz_pellet_depleted, 1, stack.func_77960_j());
        }
        if (above != null) {
            for (i = 0; i < 24; ++i) {
                ItemStack stackBottom = this.slots[i];
                ItemStack stackTop = above.slots[i];
                if (stackBottom == null && stackTop != null) {
                    this.slots[i] = stackTop.func_77946_l();
                    above.func_70298_a(i, stackTop.field_77994_a);
                }
                if (stackBottom == null || stackBottom.func_77973_b() != ModItems.watz_pellet || stackTop == null || stackTop.func_77973_b() != ModItems.watz_pellet_depleted) continue;
                ItemStack buf = stackTop.func_77946_l();
                above.slots[i] = stackBottom.func_77946_l();
                this.slots[i] = buf;
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.heat);
        buf.writeBoolean(this.isOn);
        buf.writeBoolean(this.isLocked);
        buf.writeDouble(this.fluxLastReaction + this.fluxLastBase);
        for (FluidTank tank : this.sharedTanks) {
            tank.serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.heat = buf.readInt();
        this.isOn = buf.readBoolean();
        this.isLocked = buf.readBoolean();
        this.fluxDisplay = buf.readDouble();
        for (FluidTank tank : this.tanks) {
            tank.deserialize(buf);
        }
    }

    public boolean updateLock() {
        return Compat.getTileStandard(this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e) instanceof TileEntityWatz;
    }

    protected void subscribeToTop() {
        this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e, ForgeDirection.UP);
        this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, this.field_145851_c + 2, this.field_145848_d + 3, this.field_145849_e, ForgeDirection.UP);
        this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, this.field_145851_c - 2, this.field_145848_d + 3, this.field_145849_e, ForgeDirection.UP);
        this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e + 2, ForgeDirection.UP);
        this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e - 2, ForgeDirection.UP);
    }

    protected void sendOutBottom() {
        for (DirPos pos : this.getSendingPos()) {
            if (this.tanks[1].getFill() > 0) {
                this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            if (this.tanks[2].getFill() <= 0) continue;
            this.sendFluid(this.tanks[2], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    protected DirPos[] getSendingPos() {
        return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, ForgeDirection.DOWN), new DirPos(this.field_145851_c + 2, this.field_145848_d - 1, this.field_145849_e, ForgeDirection.DOWN), new DirPos(this.field_145851_c - 2, this.field_145848_d - 1, this.field_145849_e, ForgeDirection.DOWN), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e + 2, ForgeDirection.DOWN), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e - 2, ForgeDirection.DOWN)};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        int i;
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("locks", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.locks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
        for (i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
        this.heat = nbt.func_74762_e("heat");
        this.fluxLastBase = nbt.func_74769_h("lastFluxB");
        this.fluxLastReaction = nbt.func_74769_h("lastFluxR");
        this.isLocked = nbt.func_74767_n("isLocked");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        int i;
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        for (i = 0; i < this.locks.length; ++i) {
            if (this.locks[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.locks[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("locks", (NBTBase)list);
        for (i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74780_a("lastFluxB", this.fluxLastBase);
        nbt.func_74780_a("lastFluxR", this.fluxLastReaction);
        nbt.func_74757_a("isLocked", this.isLocked);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("lock")) {
            if (this.isLocked) {
                this.locks = new ItemStack[this.slots.length];
            } else {
                for (int i = 0; i < this.slots.length; ++i) {
                    this.locks[i] = this.slots[i];
                }
            }
            this.isLocked = !this.isLocked;
            this.markChanged();
        }
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        if (stack.func_77973_b() != ModItems.watz_pellet) {
            return false;
        }
        if (!this.isLocked) {
            return true;
        }
        return this.locks[i] != null && this.locks[i].func_77973_b() == stack.func_77973_b() && this.locks[i].func_77960_j() == stack.func_77960_j();
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    }

    @Override
    public boolean func_102008_b(int i, ItemStack stack, int j) {
        return stack.func_77973_b() != ModItems.watz_pellet;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)this.field_145848_d, (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 4), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 4));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    private void disassemble() {
        int count = 20;
        Random rand = this.field_145850_b.field_73012_v;
        for (int i = 0; i < count * 5; ++i) {
            EntityShrapnel shrapnel = new EntityShrapnel(this.field_145850_b);
            shrapnel.field_70165_t = (double)this.field_145851_c + 0.5;
            shrapnel.field_70163_u = this.field_145848_d + 3;
            shrapnel.field_70161_v = (double)this.field_145849_e + 0.5;
            shrapnel.field_70181_x = ((double)rand.nextFloat() * 0.5 + 0.5) * (double)(1 + count / (15 + rand.nextInt(21))) + (double)(rand.nextFloat() / 50.0f * (float)count);
            shrapnel.field_70159_w = rand.nextGaussian() * 1.0 * (double)(1 + count / 100);
            shrapnel.field_70179_y = rand.nextGaussian() * 1.0 * (double)(1 + count / 100);
            shrapnel.setWatz(true);
            this.field_145850_b.func_72838_d((Entity)shrapnel);
        }
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.mud_block);
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, ModBlocks.mud_block);
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e, ModBlocks.mud_block);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 1, 0);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 2, 0);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 0, 1);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 0, 2);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, -1, 0);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, -2, 0);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 0, -1);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 0, -2);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 1, 1);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 1, -1);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, -1, 1);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, -1, -1);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, 2, 1);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, 2, -1);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, 1, 2);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, -1, 2);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, -2, 1);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, -2, -1);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, 1, -2);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, -1, -2);
        for (int j = -1; j < 2; ++j) {
            this.setBrokenColumn(1, ModBlocks.watz_end, 1, 3, j);
            this.setBrokenColumn(1, ModBlocks.watz_end, 1, j, 3);
            this.setBrokenColumn(1, ModBlocks.watz_end, 1, -3, j);
            this.setBrokenColumn(1, ModBlocks.watz_end, 1, j, -3);
        }
        this.setBrokenColumn(1, ModBlocks.watz_end, 1, 2, 2);
        this.setBrokenColumn(1, ModBlocks.watz_end, 1, 2, -2);
        this.setBrokenColumn(1, ModBlocks.watz_end, 1, -2, 2);
        this.setBrokenColumn(1, ModBlocks.watz_end, 1, -2, -2);
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5)).func_72314_b(50.0, 50.0, 50.0));
        for (EntityPlayer player : players) {
            player.func_71029_a((StatBase)MainRegistry.achWatzBoom);
        }
    }

    private void setBrokenColumn(int minHeight, Block b, int meta, int x, int z) {
        int height = minHeight + this.field_145850_b.field_73012_v.nextInt(3 - minHeight);
        for (int i = 0; i < 3; ++i) {
            if (i <= height) {
                this.field_145850_b.func_147465_d(this.field_145851_c + x, this.field_145848_d + i, this.field_145849_e + z, b, meta, 3);
                continue;
            }
            this.field_145850_b.func_147449_b(this.field_145851_c + x, this.field_145848_d + i, this.field_145849_e + z, ModBlocks.mud_block);
        }
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerWatz(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIWatz(player.field_71071_by, this);
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1], this.tanks[2]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank getTankToPaste() {
        return null;
    }
}

