/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardSender;
import com.hbm.handler.ThreeInts;
import com.hbm.handler.atmosphere.AtmosphereBlob;
import com.hbm.handler.atmosphere.ChunkAtmosphereManager;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityAirPump;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAirScrubber
extends TileEntityMachineBase
implements IFluidStandardSender,
IEnergyReceiverMK2 {
    private TileEntityAirPump pump;
    public FluidTank tank = new FluidTank(Fluids.CARBONDIOXIDE, 16000);
    private long power;
    public float rot;
    public float prevRot;
    private float rotSpeed;
    AxisAlignedBB bb = null;

    public TileEntityAirScrubber() {
        super(0);
    }

    @Override
    public String getName() {
        return "container.airScrubber";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.canOperate() && this.field_145850_b.func_82737_E() % 5L == 0L && (this.pump == null || this.pump.getFluidPressure() == 0.0 || !this.pump.registerScrubber(this))) {
                this.pump = null;
                List<AtmosphereBlob> blobs = ChunkAtmosphereManager.proxy.getBlobs(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                Iterator iterator = blobs.iterator();
                while (iterator.hasNext()) {
                    AtmosphereBlob blob = (AtmosphereBlob)iterator.next();
                    if (blob == null) continue;
                    ThreeInts pos = blob.getRootPosition();
                    TileEntity te = this.field_145850_b.func_147438_o(pos.x, pos.y, pos.z);
                    if (te == null || !(te instanceof TileEntityAirPump)) continue;
                    this.pump = (TileEntityAirPump)te;
                    if (this.pump.registerScrubber(this)) break;
                    this.pump = null;
                }
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
                if (this.tank.getFill() <= 0) continue;
                this.sendFluid(this.tank, this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
            }
            this.networkPackNT(20);
        } else {
            float maxSpeed = 30.0f;
            if (this.canOperate()) {
                this.rotSpeed = (float)((double)this.rotSpeed + 0.2);
                if (this.rotSpeed > maxSpeed) {
                    this.rotSpeed = maxSpeed;
                }
            } else {
                this.rotSpeed = (float)((double)this.rotSpeed - 0.1);
                if (this.rotSpeed < 0.0f) {
                    this.rotSpeed = 0.0f;
                }
            }
            this.prevRot = this.rot;
            this.rot += this.rotSpeed;
            if (this.rot >= 360.0f) {
                this.rot -= 360.0f;
                this.prevRot -= 360.0f;
            }
        }
    }

    public boolean canOperate() {
        return this.power > 200L;
    }

    public int scrub(int amount) {
        if (!this.canOperate()) {
            return 0;
        }
        int add = Math.min(this.tank.getMaxFill() - this.tank.getFill(), amount);
        this.tank.setFill(this.tank.getFill() + add);
        this.power -= (long)(add * 10);
        return add;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.tank.deserialize(buf);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tank.writeToNBT(nbt, "t");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tank.readFromNBT(nbt, "t");
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 10000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1));
        }
        return this.bb;
    }
}

