/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity.rocket.part;

import com.hbm.dim.CelestialBody;
import com.hbm.entity.missile.EntityRideableRocket;
import com.hbm.main.ResourceManager;
import com.hbm.render.entity.rocket.part.RenderRocketPart;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class RenderDropPod
extends RenderRocketPart {
    private boolean brakes;
    private long brakeStart;

    @Override
    public void render(TextureManager tex, EntityRideableRocket rocket, float interp) {
        tex.func_110577_a(ResourceManager.drop_pod_tex);
        if (CelestialBody.inOrbit(rocket.field_70170_p)) {
            ResourceManager.drop_pod.renderAll();
            return;
        }
        EntityRideableRocket.RocketState state = rocket.getState();
        int timer = rocket.getStateTimer();
        float lerpTimer = (float)timer + interp;
        ResourceManager.drop_pod.renderPart("DropPod");
        GL11.glPushMatrix();
        float doorRotation = 0.0f;
        if (state == EntityRideableRocket.RocketState.LANDED) {
            doorRotation = MathHelper.func_76131_a((float)(lerpTimer * 2.0f), (float)0.0f, (float)90.0f);
        } else if (state == EntityRideableRocket.RocketState.AWAITING) {
            doorRotation = MathHelper.func_76131_a((float)(90.0f - lerpTimer * 2.0f), (float)0.0f, (float)90.0f);
        }
        GL11.glTranslatef((float)0.69291f, (float)2.8333f, (float)0.0f);
        GL11.glRotatef((float)doorRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.69291f, (float)-2.8333f, (float)0.0f);
        ResourceManager.drop_pod.renderPart("Door");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        float brakeRotation = 0.0f;
        if (state == EntityRideableRocket.RocketState.LANDING) {
            if (rocket.field_70181_x > (double)-0.4f) {
                if (this.brakes) {
                    this.brakes = false;
                    this.brakeStart = System.currentTimeMillis();
                }
            } else {
                this.brakes = true;
            }
            if (!this.brakes) {
                float t = MathHelper.func_76131_a((float)((float)(System.currentTimeMillis() - this.brakeStart) / 1000.0f), (float)0.0f, (float)1.0f);
                brakeRotation = (1.0f - t) * 65.0f;
            } else {
                brakeRotation = 65.0f;
            }
        }
        for (int i = 0; i < 4; ++i) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)(i * 90 - 45), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)0.46194, (double)3.5, (double)0.0);
            GL11.glRotatef((float)brakeRotation, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)-0.46194, (double)-3.5, (double)0.0);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            ResourceManager.drop_pod.renderPart("Airbrake0");
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        double legExtension = 1.0;
        if (state == EntityRideableRocket.RocketState.LAUNCHING) {
            legExtension = 0.0;
        }
        GL11.glTranslated((double)0.0, (double)(-legExtension * 0.5), (double)0.0);
        ResourceManager.drop_pod.renderPart("Legs");
        GL11.glPopMatrix();
    }
}

