/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.container.ContainerMachineRocketAssembly;
import com.hbm.inventory.gui.GuiInfoContainerLayered;
import com.hbm.items.ItemVOTVdrive;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.render.util.MissilePronter;
import com.hbm.tileentity.machine.TileEntityMachineRocketAssembly;
import com.hbm.util.i18n.I18nUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GUIMachineRocketAssembly
extends GuiInfoContainerLayered {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/machine/gui_rocket_assembly.png");
    private TileEntityMachineRocketAssembly machine;
    private double currentOffset = 0.0;
    private double currentScale = 1.0;
    private long lastTime = 0L;

    public GUIMachineRocketAssembly(InventoryPlayer invPlayer, TileEntityMachineRocketAssembly machine) {
        super(new ContainerMachineRocketAssembly(invPlayer, machine));
        this.machine = machine;
        this.field_146999_f = 192;
        this.field_147000_g = 224;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.lastTime = System.nanoTime();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int stage = Math.max(this.machine.rocket.stages.size() - 1 - this.getLayer(), -1);
        this.func_73729_b(this.field_147003_i + 47, this.field_147009_r + 39, this.field_146999_f + 18 + (stage + 1) * 6, 0, 6, 8);
        stage = Math.max(stage, 0);
        double dt = (double)(System.nanoTime() - this.lastTime) / 1.0E9;
        this.lastTime = System.nanoTime();
        GL11.glPushMatrix();
        this.pushScissor(65, 5, 90, 106);
        GL11.glTranslatef((float)(this.field_147003_i + 116), (float)(this.field_147009_r + 103), (float)100.0f);
        GL11.glRotatef((float)(System.currentTimeMillis() / 10L % 360L), (float)0.0f, (float)-1.0f, (float)0.0f);
        double size = 86.0;
        double height = this.machine.rocket.getHeight(stage);
        double targetScale = size / Math.max(height, 6.0);
        this.currentScale += (targetScale - this.currentScale) * dt * 4.0;
        double targetOffset = this.machine.rocket.getOffset(stage);
        this.currentOffset += (targetOffset - this.currentOffset) * dt * 4.0;
        GL11.glScaled((double)(-this.currentScale), (double)(-this.currentScale), (double)(-this.currentScale));
        GL11.glTranslated((double)0.0, (double)(-this.currentOffset), (double)0.0);
        MissilePronter.prontRocket(this.machine.rocket, Minecraft.func_71410_x().func_110434_K());
        this.popScissor();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)150.0f);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        ItemStack fromStack = this.machine.slots[this.machine.slots.length - (5 - this.currentLayer) * 2];
        ItemStack toStack = this.machine.slots[this.machine.slots.length - (5 - this.currentLayer) * 2 + 1];
        ItemVOTVdrive.Target from = ItemVOTVdrive.getTarget(fromStack, this.machine.func_145831_w());
        ItemVOTVdrive.Target to = ItemVOTVdrive.getTarget(toStack, this.machine.func_145831_w());
        List<String> issues = this.machine.rocket.findIssues(stage, from.body, to.body, from.inOrbit, to.inOrbit);
        for (int i = 0; i < issues.size(); ++i) {
            String issue = issues.get(i);
            this.field_146289_q.func_78261_a(issue, (this.field_147003_i + 65) * 2, (this.field_147009_r + 5) * 2 + i * 8, 0xFFFFFF);
        }
        if (from.body != null) {
            this.field_146289_q.func_78276_b(I18nUtil.resolveKey("body." + from.body.name, new Object[0]), (this.field_147003_i + 162) * 2, (this.field_147009_r + 75) * 2, 65280);
        }
        if (to.body != null) {
            this.field_146289_q.func_78276_b(I18nUtil.resolveKey("body." + to.body.name, new Object[0]), (this.field_147003_i + 162) * 2, (this.field_147009_r + 108) * 2, 65280);
        }
        GL11.glPopMatrix();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        if (this.checkClick(mouseX, mouseY, 17, 34, 18, 8)) {
            this.func_73729_b(17, 34, this.field_146999_f, 36, 18, 8);
        }
        if (this.checkClick(mouseX, mouseY, 17, 98, 18, 8)) {
            this.func_73729_b(17, 98, this.field_146999_f, 44, 18, 8);
        }
        if (this.machine.rocket.validate()) {
            this.func_73729_b(41, 62, this.field_146999_f + 18, 8, 18, 18);
        }
        if (this.machine.canDeconstruct()) {
            this.func_73729_b(39, 52, this.field_146999_f + 36, 8, 20, 38);
        }
    }

    protected void func_73864_a(int x, int y, int i) {
        super.func_73864_a(x, y, i);
        if (this.checkClick(x, y, 17, 34, 18, 8)) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            if (this.getLayer() > 0) {
                this.setLayer(this.getLayer() - 1);
            }
        }
        if (this.checkClick(x, y, 17, 98, 18, 8)) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            if (this.getLayer() < Math.min(this.machine.rocket.stages.size(), 4)) {
                this.setLayer(this.getLayer() + 1);
            }
        }
        if (this.checkClick(x, y, 41, 62, 18, 18)) {
            if (this.machine.rocket.validate()) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                NBTTagCompound data = new NBTTagCompound();
                data.func_74757_a("construct", true);
                PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.machine.field_145851_c, this.machine.field_145848_d, this.machine.field_145849_e));
            } else if (this.machine.canDeconstruct()) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                NBTTagCompound data = new NBTTagCompound();
                data.func_74757_a("deconstruct", true);
                PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.machine.field_145851_c, this.machine.field_145848_d, this.machine.field_145849_e));
            }
        }
    }
}

