/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.imc.ICompatNHNEI;
import com.hbm.inventory.gui.GUIMachineGasCent;
import com.hbm.inventory.recipes.GasCentrifugeRecipes;
import com.hbm.inventory.recipes.MachineRecipes;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class GasCentrifugeRecipeHandler
extends TemplateRecipeHandler
implements ICompatNHNEI {
    public static ArrayList<Fuel> fuels;
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsRec = new LinkedList();
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsGui = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiRec = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiGui = new LinkedList();

    @Override
    public ItemStack[] getMachinesForRecipe() {
        return new ItemStack[]{new ItemStack(ModBlocks.machine_gascent)};
    }

    @Override
    public String getRecipeID() {
        return "gascentprocessing";
    }

    public String getRecipeName() {
        return "Gas Centrifuge";
    }

    public String getGuiTexture() {
        return "hbm:textures/gui/nei/gui_nei_centrifuge_gas.png";
    }

    public TemplateRecipeHandler newInstance() {
        if (fuels == null || fuels.isEmpty()) {
            fuels = new ArrayList();
        }
        for (ItemStack i : MachineRecipes.instance().getBatteries()) {
            fuels.add(new Fuel(i));
        }
        return super.newInstance();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("gascentprocessing") && this.getClass() == GasCentrifugeRecipeHandler.class) {
            Map<Object, Object[]> recipes = GasCentrifugeRecipes.getGasCentrifugeRecipes();
            for (Map.Entry<Object, Object[]> recipe : recipes.entrySet()) {
                this.arecipes.add(new SmeltingSet((ItemStack)recipe.getKey(), (ItemStack[])recipe.getValue()[0], (Boolean)recipe.getValue()[1], (Integer)recipe.getValue()[2]));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        Map<Object, Object[]> recipes = GasCentrifugeRecipes.getGasCentrifugeRecipes();
        for (Map.Entry<Object, Object[]> recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)((ItemStack[])recipe.getValue()[0])[0], (ItemStack)result) && !NEIServerUtils.areStacksSameType((ItemStack)((ItemStack[])recipe.getValue()[0])[1], (ItemStack)result) && !NEIServerUtils.areStacksSameType((ItemStack)((ItemStack[])recipe.getValue()[0])[2], (ItemStack)result) && !NEIServerUtils.areStacksSameType((ItemStack)((ItemStack[])recipe.getValue()[0])[3], (ItemStack)result)) continue;
            this.arecipes.add(new SmeltingSet((ItemStack)recipe.getKey(), (ItemStack[])recipe.getValue()[0], (Boolean)recipe.getValue()[1], (Integer)recipe.getValue()[2]));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("gascentprocessing") && this.getClass() == GasCentrifugeRecipeHandler.class) {
            this.loadCraftingRecipes("gascentprocessing", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map<Object, Object[]> recipes = GasCentrifugeRecipes.getGasCentrifugeRecipes();
        for (Map.Entry<Object, Object[]> recipe : recipes.entrySet()) {
            if (!this.compareFluidStacks(ingredient, (ItemStack)recipe.getKey())) continue;
            this.arecipes.add(new SmeltingSet((ItemStack)recipe.getKey(), (ItemStack[])recipe.getValue()[0], (Boolean)recipe.getValue()[1], (Integer)recipe.getValue()[2]));
        }
    }

    private boolean compareFluidStacks(ItemStack sta1, ItemStack sta2) {
        return sta1.func_77973_b() == sta2.func_77973_b() && sta1.func_77960_j() == sta2.func_77960_j();
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(3, 6, 176, 0, 16, 34, 480, 7);
        SmeltingSet set = (SmeltingSet)((Object)this.arecipes.get(recipe));
        this.drawProgressBar(74, 17, 208, 0, 44, 37, set.isHighSpeed ? 80 : 150, 0);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String centrifuges = set.centNumber + " G. Cents";
        fontRenderer.func_78276_b(centrifuges, 50 - fontRenderer.func_78256_a(centrifuges) / 2, 10, 65280);
    }

    public void loadTransferRects() {
        this.transferRectsGui = new LinkedList();
        this.guiGui = new LinkedList();
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 15, 44, 40), "gascentprocessing", new Object[0]));
        this.transferRectsGui.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 25, 36, 12), "gascentprocessing", new Object[0]));
        this.guiGui.add(GUIMachineGasCent.class);
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis((List)this.getRecipeTransferRectGuis(), (List)this.transferRects);
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis(this.guiGui, this.transferRectsGui);
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
        SmeltingSet set = (SmeltingSet)((Object)this.arecipes.get(recipe));
        if (set.isHighSpeed) {
            GuiDraw.drawTexturedModalRect((int)25, (int)24, (int)192, (int)0, (int)16, (int)16);
        }
    }

    public static class Fuel {
        public PositionedStack stack;

        public Fuel(ItemStack ingred) {
            this.stack = new PositionedStack((Object)ingred, 3, 42, false);
        }
    }

    public class SmeltingSet
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        List<PositionedStack> output;
        boolean isHighSpeed;
        int centNumber;

        public SmeltingSet(ItemStack input, ItemStack[] results, boolean isHighSpeed, int centNumber) {
            super((TemplateRecipeHandler)GasCentrifugeRecipeHandler.this);
            this.output = new ArrayList<PositionedStack>();
            input.field_77994_a = 1;
            this.input = new PositionedStack((Object)input, 47, 24);
            this.isHighSpeed = isHighSpeed;
            this.centNumber = centNumber;
            for (int i = 0; i < results.length; i = (int)((byte)(i + 1))) {
                this.output.add(new PositionedStack((Object)results[i], i % 2 == 0 ? 129 : 147, i < 2 ? 15 : 33));
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(GasCentrifugeRecipeHandler.this.cycleticks / 48, Arrays.asList(this.input));
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(GasCentrifugeRecipeHandler.fuels.get((int)(GasCentrifugeRecipeHandler.this.cycleticks / 48 % GasCentrifugeRecipeHandler.fuels.size())).stack);
            stacks.addAll(this.output);
            return stacks;
        }

        public PositionedStack getResult() {
            return this.output.get(0);
        }
    }
}

