/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.ability;

import com.hbm.config.ToolConfig;
import com.hbm.handler.ability.IBaseAbility;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.CentrifugeRecipes;
import com.hbm.inventory.recipes.CrystallizerRecipes;
import com.hbm.inventory.recipes.ShredderRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemToolAbility;
import com.hbm.util.EnchantmentUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.world.World;

public interface IToolHarvestAbility
extends IBaseAbility {
    public static final int SORT_ORDER_BASE = 100;
    public static final IToolHarvestAbility NONE = new IToolHarvestAbility(){

        @Override
        public String getName() {
            return "";
        }

        @Override
        public int sortOrder() {
            return 100;
        }
    };
    public static final IToolHarvestAbility SILK = new IToolHarvestAbility(){

        @Override
        public String getName() {
            return "tool.ability.silktouch";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilitySilk;
        }

        @Override
        public int sortOrder() {
            return 101;
        }

        @Override
        public void preHarvestAll(int level, World world, EntityPlayer player) {
            ItemStack stack = player.func_70694_bm();
            if (stack != null) {
                EnchantmentUtil.addEnchantment(stack, Enchantment.field_77348_q, 1);
            }
        }

        @Override
        public void postHarvestAll(int level, World world, EntityPlayer player) {
            ItemStack stack = player.func_70694_bm();
            if (stack != null) {
                EnchantmentUtil.removeEnchantment(stack, Enchantment.field_77348_q);
            }
        }
    };
    public static final IToolHarvestAbility LUCK = new IToolHarvestAbility(){
        public final int[] powerAtLevel = new int[]{1, 2, 3, 4, 5, 9};

        @Override
        public String getName() {
            return "tool.ability.luck";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityLuck;
        }

        @Override
        public int levels() {
            return this.powerAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.powerAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 102;
        }

        @Override
        public void preHarvestAll(int level, World world, EntityPlayer player) {
            ItemStack stack = player.func_70694_bm();
            if (stack != null) {
                EnchantmentUtil.addEnchantment(stack, Enchantment.field_77346_s, this.powerAtLevel[level]);
            }
        }

        @Override
        public void postHarvestAll(int level, World world, EntityPlayer player) {
            ItemStack stack = player.func_70694_bm();
            if (stack != null) {
                EnchantmentUtil.removeEnchantment(stack, Enchantment.field_77346_s);
            }
        }
    };
    public static final IToolHarvestAbility SMELTER = new IToolHarvestAbility(){

        @Override
        public String getName() {
            return "tool.ability.smelter";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityFurnace;
        }

        @Override
        public int sortOrder() {
            return 103;
        }

        @Override
        public void onHarvestBlock(int level, World world, int x, int y, int z, EntityPlayer player, Block block, int meta) {
            ArrayList drops = block.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
            boolean doesSmelt = false;
            for (int i = 0; i < drops.size(); ++i) {
                ItemStack stack = ((ItemStack)drops.get(i)).func_77946_l();
                ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
                if (result == null) continue;
                result = result.func_77946_l();
                result.field_77994_a *= stack.field_77994_a;
                drops.set(i, result);
                doesSmelt = true;
            }
            IToolHarvestAbility.harvestBlock(doesSmelt, world, x, y, z, player);
            if (doesSmelt) {
                for (ItemStack stack : drops) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)ItemToolAbility.dropX + 0.5, (double)ItemToolAbility.dropY + 0.5, (double)ItemToolAbility.dropZ + 0.5, stack.func_77946_l()));
                }
            }
        }
    };
    public static final IToolHarvestAbility SHREDDER = new IToolHarvestAbility(){

        @Override
        public String getName() {
            return "tool.ability.shredder";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityShredder;
        }

        @Override
        public int sortOrder() {
            return 104;
        }

        @Override
        public void onHarvestBlock(int level, World world, int x, int y, int z, EntityPlayer player, Block block, int meta) {
            ItemStack stack;
            ItemStack result;
            if (block == Blocks.field_150439_ay) {
                block = Blocks.field_150450_ax;
            }
            boolean doesShred = (result = ShredderRecipes.getShredderResult(stack = new ItemStack(block, 1, meta))) != null && result.func_77973_b() != ModItems.scrap;
            IToolHarvestAbility.harvestBlock(doesShred, world, x, y, z, player);
            if (doesShred) {
                world.func_72838_d((Entity)new EntityItem(world, (double)ItemToolAbility.dropX + 0.5, (double)ItemToolAbility.dropY + 0.5, (double)ItemToolAbility.dropZ + 0.5, result.func_77946_l()));
            }
        }
    };
    public static final IToolHarvestAbility CENTRIFUGE = new IToolHarvestAbility(){

        @Override
        public String getName() {
            return "tool.ability.centrifuge";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityCentrifuge;
        }

        @Override
        public int sortOrder() {
            return 105;
        }

        @Override
        public void onHarvestBlock(int level, World world, int x, int y, int z, EntityPlayer player, Block block, int meta) {
            ItemStack stack;
            ItemStack[] result;
            if (block == Blocks.field_150439_ay) {
                block = Blocks.field_150450_ax;
            }
            boolean doesCentrifuge = (result = CentrifugeRecipes.getOutput(stack = new ItemStack(block, 1, meta))) != null;
            IToolHarvestAbility.harvestBlock(doesCentrifuge, world, x, y, z, player);
            if (doesCentrifuge) {
                for (ItemStack st : result) {
                    if (st == null) continue;
                    world.func_72838_d((Entity)new EntityItem(world, (double)ItemToolAbility.dropX + 0.5, (double)ItemToolAbility.dropY + 0.5, (double)ItemToolAbility.dropZ + 0.5, st.func_77946_l()));
                }
            }
        }
    };
    public static final IToolHarvestAbility CRYSTALLIZER = new IToolHarvestAbility(){

        @Override
        public String getName() {
            return "tool.ability.crystallizer";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityCrystallizer;
        }

        @Override
        public int sortOrder() {
            return 106;
        }

        @Override
        public void onHarvestBlock(int level, World world, int x, int y, int z, EntityPlayer player, Block block, int meta) {
            ItemStack stack;
            CrystallizerRecipes.CrystallizerRecipe result;
            if (block == Blocks.field_150439_ay) {
                block = Blocks.field_150450_ax;
            }
            boolean doesCrystallize = (result = CrystallizerRecipes.getOutput(stack = new ItemStack(block, 1, meta), Fluids.PEROXIDE)) != null;
            IToolHarvestAbility.harvestBlock(doesCrystallize, world, x, y, z, player);
            if (doesCrystallize) {
                world.func_72838_d((Entity)new EntityItem(world, (double)ItemToolAbility.dropX + 0.5, (double)ItemToolAbility.dropY + 0.5, (double)ItemToolAbility.dropZ + 0.5, result.output.func_77946_l()));
            }
        }
    };
    public static final IToolHarvestAbility MERCURY = new IToolHarvestAbility(){

        @Override
        public String getName() {
            return "tool.ability.mercury";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityMercury;
        }

        @Override
        public int sortOrder() {
            return 107;
        }

        @Override
        public void onHarvestBlock(int level, World world, int x, int y, int z, EntityPlayer player, Block block, int meta) {
            if (block == Blocks.field_150439_ay) {
                block = Blocks.field_150450_ax;
            }
            int mercury = 0;
            if (block == Blocks.field_150450_ax) {
                mercury = player.func_70681_au().nextInt(5) + 4;
            }
            if (block == Blocks.field_150451_bX) {
                mercury = player.func_70681_au().nextInt(7) + 8;
            }
            boolean doesConvert = mercury > 0;
            IToolHarvestAbility.harvestBlock(doesConvert, world, x, y, z, player);
            if (doesConvert) {
                world.func_72838_d((Entity)new EntityItem(world, (double)ItemToolAbility.dropX + 0.5, (double)ItemToolAbility.dropY + 0.5, (double)ItemToolAbility.dropZ + 0.5, new ItemStack(ModItems.ingot_mercury, mercury)));
            }
        }
    };
    public static final IToolHarvestAbility[] abilities = new IToolHarvestAbility[]{NONE, SILK, LUCK, SMELTER, SHREDDER, CENTRIFUGE, CRYSTALLIZER, MERCURY};

    default public void preHarvestAll(int level, World world, EntityPlayer player) {
    }

    default public void postHarvestAll(int level, World world, EntityPlayer player) {
    }

    default public void onHarvestBlock(int level, World world, int x, int y, int z, EntityPlayer player, Block block, int meta) {
        IToolHarvestAbility.harvestBlock(false, world, x, y, z, player);
    }

    public static void harvestBlock(boolean skipDefaultDrops, World world, int x, int y, int z, EntityPlayer player) {
        if (skipDefaultDrops) {
            world.func_147468_f(x, y, z);
            ItemStack stack = player.func_70694_bm();
            if (stack != null) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
        } else if (player instanceof EntityPlayerMP) {
            ItemToolAbility.standardDigPost(world, x, y, z, (EntityPlayerMP)player);
        }
    }

    public static IToolHarvestAbility getByName(String name) {
        for (IToolHarvestAbility ability : abilities) {
            if (!ability.getName().equals(name)) continue;
            return ability;
        }
        return NONE;
    }
}

