/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.BombConfig;
import com.hbm.entity.effect.EntityBlackHole;
import com.hbm.entity.effect.EntityCloudFleija;
import com.hbm.entity.effect.EntityEMPBlast;
import com.hbm.entity.logic.EntityNukeExplosionMK3;
import com.hbm.entity.missile.EntityMissileBaseNT;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.explosion.ExplosionNukeSmall;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.material.Mats;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.factory.GunFactory;
import com.hbm.world.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class EntityMissileTier0
extends EntityMissileBaseNT {
    public EntityMissileTier0(World world) {
        super(world);
    }

    public EntityMissileTier0(World world, float x, float y, float z, int a, int b) {
        super(world, x, y, z, a, b);
    }

    @Override
    public List<ItemStack> getDebris() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(ModItems.wire_fine, 4, Mats.MAT_ALUMINIUM.id));
        list.add(new ItemStack(ModItems.plate_titanium, 4));
        list.add(new ItemStack(ModItems.shell, 2, Mats.MAT_ALUMINIUM.id));
        list.add(new ItemStack(ModItems.ducttape, 1));
        return list;
    }

    @Override
    protected float getContrailScale() {
        return 0.5f;
    }

    public static class EntityMissileEMP
    extends EntityMissileTier0 {
        public EntityMissileEMP(World world) {
            super(world);
        }

        public EntityMissileEMP(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onMissileImpact(MovingObjectPosition mop) {
            ExplosionNukeGeneric.empBlast(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 50);
            EntityEMPBlast wave = new EntityEMPBlast(this.field_70170_p, 50);
            wave.field_70165_t = this.field_70165_t;
            wave.field_70163_u = this.field_70163_u;
            wave.field_70161_v = this.field_70161_v;
            this.field_70170_p.func_72838_d((Entity)wave);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModBlocks.emp_bomb, 1);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_emp);
        }
    }

    public static class EntityMissileTaint
    extends EntityMissileTier0 {
        public EntityMissileTaint(World world) {
            super(world);
        }

        public EntityMissileTaint(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onMissileImpact(MovingObjectPosition mop) {
            this.field_70170_p.func_72876_a((Entity)this, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, 5.0f, true);
            for (int i = 0; i < 100; ++i) {
                int c;
                int b;
                int a = this.field_70146_Z.nextInt(11) + mop.field_72311_b - 5;
                Block block = this.field_70170_p.func_147439_a(a, b = this.field_70146_Z.nextInt(11) + mop.field_72312_c - 5, c = this.field_70146_Z.nextInt(11) + mop.field_72309_d - 5);
                if (!block.func_149721_r() || block.isAir((IBlockAccess)this.field_70170_p, a, b, c)) continue;
                this.field_70170_p.func_147465_d(a, b, c, ModBlocks.taint, 0, 2);
            }
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.powder_spark_mix, 1);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_taint);
        }
    }

    public static class EntityMissileBHole
    extends EntityMissileTier0 {
        public EntityMissileBHole(World world) {
            super(world);
        }

        public EntityMissileBHole(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onMissileImpact(MovingObjectPosition mop) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.5f, true);
            EntityBlackHole bl = new EntityBlackHole(this.field_70170_p, 1.5f);
            bl.field_70165_t = this.field_70165_t;
            bl.field_70163_u = this.field_70163_u;
            bl.field_70161_v = this.field_70161_v;
            this.field_70170_p.func_72838_d((Entity)bl);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.grenade_black_hole, 1);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_bhole);
        }
    }

    public static class EntityMissileSchrabidium
    extends EntityMissileTier0 {
        public EntityMissileSchrabidium(World world) {
            super(world);
        }

        public EntityMissileSchrabidium(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onMissileImpact(MovingObjectPosition mop) {
            EntityNukeExplosionMK3 ex = EntityNukeExplosionMK3.statFacFleija(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, BombConfig.aSchrabRadius);
            if (!ex.field_70128_L) {
                WorldUtil.loadAndSpawnEntityInWorld(ex);
                EntityCloudFleija cloud = new EntityCloudFleija(this.field_70170_p, BombConfig.aSchrabRadius);
                cloud.field_70165_t = this.field_70165_t;
                cloud.field_70163_u = this.field_70163_u;
                cloud.field_70161_v = this.field_70161_v;
                this.field_70170_p.func_72838_d((Entity)cloud);
            }
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return null;
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_schrabidium);
        }
    }

    public static class EntityMissileMicro
    extends EntityMissileTier0 {
        public EntityMissileMicro(World world) {
            super(world);
        }

        public EntityMissileMicro(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onMissileImpact(MovingObjectPosition mop) {
            ExplosionNukeSmall.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, ExplosionNukeSmall.PARAMS_HIGH);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return OreDictManager.DictFrame.fromOne(ModItems.ammo_standard, (Enum)GunFactory.EnumAmmo.NUKE_HIGH);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_micro);
        }
    }

    public static class EntityMissileTest
    extends EntityMissileTier0 {
        public EntityMissileTest(World world) {
            super(world);
        }

        public EntityMissileTest(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return null;
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_test);
        }

        @Override
        public void onMissileImpact(MovingObjectPosition mop) {
            int x = (int)Math.floor(this.field_70165_t);
            int y = (int)Math.floor(this.field_70163_u);
            int z = (int)Math.floor(this.field_70161_v);
            int range = 50;
            for (int iX = -range; iX <= range; ++iX) {
                for (int iY = -range; iY <= range; ++iY) {
                    for (int iZ = -range; iZ <= range; ++iZ) {
                        double dist = Math.sqrt(iX * iX + iY * iY + iZ * iZ);
                        if (dist > (double)range) continue;
                        Block block = this.field_70170_p.func_147439_a(x + iX, y + iY, z + iZ);
                        int meta = this.field_70170_p.func_72805_g(x + iX, y + iY, z + iZ);
                        int charMeta = (int)MathHelper.func_151237_a((double)(12.0 - dist / (double)range * (dist / (double)range) * 13.0), (double)0.0, (double)12.0);
                        if (block.func_149721_r()) {
                            if (block == ModBlocks.sellafield_slaked && meta >= charMeta) continue;
                            this.field_70170_p.func_147465_d(x + iX, y + iY, z + iZ, ModBlocks.sellafield_slaked, charMeta, 3);
                            continue;
                        }
                        this.field_70170_p.func_147449_b(x + iX, y + iY, z + iZ, Blocks.field_150350_a);
                    }
                }
            }
        }
    }
}

