/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.noise;

import java.util.Random;

public class PerlinFestival {
    private int[] permutation = new int[512];
    private static final int PERSISTENCE_LENGTH = 256;

    public PerlinFestival(long seed) {
        int i;
        Random random = new Random(seed);
        for (i = 0; i < 256; ++i) {
            this.permutation[i] = i;
        }
        for (i = 255; i > 0; --i) {
            int index = random.nextInt(i + 1);
            int a = this.permutation[index];
            this.permutation[index] = this.permutation[i];
            this.permutation[i] = a;
        }
        for (i = 0; i < 256; ++i) {
            this.permutation[256 + i] = this.permutation[i];
        }
    }

    private double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    private double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    private double grad(int hash, double x, double y, double z) {
        double u;
        int h = hash & 0xF;
        double d = u = h < 8 ? x : y;
        double v = h < 4 ? y : (h == 12 || h == 14 ? x : z);
        return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
    }

    public double noise(double x, double y, double z) {
        int X = (int)Math.floor(x) & 0xFF;
        int Y = (int)Math.floor(y) & 0xFF;
        int Z = (int)Math.floor(z) & 0xFF;
        x -= Math.floor(x);
        y -= Math.floor(y);
        z -= Math.floor(z);
        double u = this.fade(x);
        double v = this.fade(y);
        double w = this.fade(z);
        int A = this.permutation[X] + Y;
        int AA = this.permutation[A] + Z;
        int AB = this.permutation[A + 1] + Z;
        int B = this.permutation[X + 1] + Y;
        int BA = this.permutation[B] + Z;
        int BB = this.permutation[B + 1] + Z;
        return this.lerp(w, this.lerp(v, this.lerp(u, this.grad(this.permutation[AA], x, y, z), this.grad(this.permutation[BA], x - 1.0, y, z)), this.lerp(u, this.grad(this.permutation[AB], x, y - 1.0, z), this.grad(this.permutation[BB], x - 1.0, y - 1.0, z))), this.lerp(v, this.lerp(u, this.grad(this.permutation[AA + 1], x, y, z - 1.0), this.grad(this.permutation[BA + 1], x - 1.0, y, z - 1.0)), this.lerp(u, this.grad(this.permutation[AB + 1], x, y - 1.0, z - 1.0), this.grad(this.permutation[BB + 1], x - 1.0, y - 1.0, z - 1.0))));
    }
}

