/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim;

import com.hbm.world.WorldUtil;
import com.hbm.world.biome.BiomeGenCraterBase;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.event.terraingen.TerrainGen;

public abstract class ChunkProviderCelestial
implements IChunkProvider {
    protected Block stoneBlock;
    protected Block seaBlock;
    protected int seaLevel;
    protected Vec3 firstOrderFreq = Vec3.func_72443_a((double)684.412, (double)684.412, (double)684.412);
    protected Vec3 secondOrderFreq = Vec3.func_72443_a((double)684.412, (double)684.412, (double)684.412);
    protected Vec3 thirdOrderFreq = Vec3.func_72443_a((double)8.555150000000001, (double)4.277575000000001, (double)8.555150000000001);
    protected Vec3 heightOrderFreq = Vec3.func_72443_a((double)200.0, (double)200.0, (double)0.5);
    protected boolean amplified = false;
    protected boolean reclamp = true;
    protected World worldObj;
    protected final boolean mapFeaturesEnabled;
    protected Random rand;
    private NoiseGeneratorOctaves firstOrder;
    private NoiseGeneratorOctaves secondOrder;
    private NoiseGeneratorOctaves thirdOrder;
    private NoiseGeneratorPerlin perlin;
    private NoiseGeneratorOctaves heightOrder;
    protected BiomeGenBase[] biomesForGeneration;
    private final double[] terrainBuffer;
    private final float[] parabolicField;
    private double[] stoneNoise = new double[256];
    private double[] firstOrderBuffer;
    private double[] secondOrderBuffer;
    private double[] thirdOrderBuffer;
    private double[] heightOrderBuffer;

    public ChunkProviderCelestial(World world, long seed, boolean hasMapFeatures) {
        this.worldObj = world;
        this.mapFeaturesEnabled = hasMapFeatures;
        this.rand = new Random(seed);
        this.firstOrder = new NoiseGeneratorOctaves(this.rand, 16);
        this.secondOrder = new NoiseGeneratorOctaves(this.rand, 16);
        this.thirdOrder = new NoiseGeneratorOctaves(this.rand, 8);
        this.perlin = new NoiseGeneratorPerlin(this.rand, 4);
        this.heightOrder = new NoiseGeneratorOctaves(this.rand, 16);
        this.terrainBuffer = new double[825];
        this.parabolicField = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
        this.stoneBlock = Blocks.field_150348_b;
        this.seaBlock = Blocks.field_150350_a;
        this.seaLevel = 63;
        NoiseGenerator[] noiseGens = new NoiseGenerator[]{this.firstOrder, this.secondOrder, this.thirdOrder, this.perlin, this.heightOrder};
        noiseGens = TerrainGen.getModdedNoiseGenerators((World)world, (Random)this.rand, (NoiseGenerator[])noiseGens);
        this.firstOrder = (NoiseGeneratorOctaves)noiseGens[0];
        this.secondOrder = (NoiseGeneratorOctaves)noiseGens[1];
        this.thirdOrder = (NoiseGeneratorOctaves)noiseGens[2];
        this.perlin = (NoiseGeneratorPerlin)noiseGens[3];
        this.heightOrder = (NoiseGeneratorOctaves)noiseGens[4];
    }

    protected BlockMetaBuffer getChunkPrimer(int x, int z) {
        BlockMetaBuffer buffer = new BlockMetaBuffer();
        this.generateBlocks(x, z, buffer.blocks);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.replaceBlocksForBiome(x, z, buffer.blocks, buffer.metas, this.biomesForGeneration);
        return buffer;
    }

    protected void generateBlocks(int x, int z, Block[] blocks) {
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.generateNoiseField(x * 4, 0, z * 4);
        for (int k = 0; k < 4; ++k) {
            int l = k * 5;
            int i1 = (k + 1) * 5;
            for (int j1 = 0; j1 < 4; ++j1) {
                int k1 = (l + j1) * 33;
                int l1 = (l + j1 + 1) * 33;
                int i2 = (i1 + j1) * 33;
                int j2 = (i1 + j1 + 1) * 33;
                for (int k2 = 0; k2 < 32; ++k2) {
                    double d0 = 0.125;
                    double d1 = this.terrainBuffer[k1 + k2];
                    double d2 = this.terrainBuffer[l1 + k2];
                    double d3 = this.terrainBuffer[i2 + k2];
                    double d4 = this.terrainBuffer[j2 + k2];
                    double d5 = (this.terrainBuffer[k1 + k2 + 1] - d1) * d0;
                    double d6 = (this.terrainBuffer[l1 + k2 + 1] - d2) * d0;
                    double d7 = (this.terrainBuffer[i2 + k2 + 1] - d3) * d0;
                    double d8 = (this.terrainBuffer[j2 + k2 + 1] - d4) * d0;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            int j3 = i3 + k * 4 << 12 | 0 + j1 * 4 << 8 | k2 * 8 + l2;
                            int short1 = 256;
                            j3 -= short1;
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double d15 = d10 - d16;
                            for (int k3 = 0; k3 < 4; ++k3) {
                                double d;
                                d15 += d16;
                                blocks[j3 += short1] = d > 0.0 ? this.stoneBlock : (k2 * 8 + l2 < this.seaLevel ? this.seaBlock : Blocks.field_150350_a);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    protected void generateNoiseField(int x, int y, int z) {
        this.firstOrderBuffer = this.firstOrder.func_76304_a(this.firstOrderBuffer, x, y, z, 5, 33, 5, this.firstOrderFreq.field_72450_a, this.firstOrderFreq.field_72448_b, this.firstOrderFreq.field_72449_c);
        this.secondOrderBuffer = this.secondOrder.func_76304_a(this.secondOrderBuffer, x, y, z, 5, 33, 5, this.secondOrderFreq.field_72450_a, this.secondOrderFreq.field_72448_b, this.secondOrderFreq.field_72449_c);
        this.thirdOrderBuffer = this.thirdOrder.func_76304_a(this.thirdOrderBuffer, x, y, z, 5, 33, 5, this.thirdOrderFreq.field_72450_a, this.thirdOrderFreq.field_72448_b, this.thirdOrderFreq.field_72449_c);
        this.heightOrderBuffer = this.heightOrder.func_76305_a(this.heightOrderBuffer, x, z, 5, 5, this.heightOrderFreq.field_72450_a, this.heightOrderFreq.field_72448_b, this.heightOrderFreq.field_72449_c);
        int l = 0;
        int i1 = 0;
        for (int j1 = 0; j1 < 5; ++j1) {
            for (int k1 = 0; k1 < 5; ++k1) {
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                int b0 = 2;
                BiomeGenBase biomegenbase = this.biomesForGeneration[j1 + 2 + (k1 + 2) * 10];
                for (int l1 = -b0; l1 <= b0; ++l1) {
                    for (int i2 = -b0; i2 <= b0; ++i2) {
                        BiomeGenBase biomegenbase1 = this.biomesForGeneration[j1 + l1 + 2 + (k1 + i2 + 2) * 10];
                        float f3 = biomegenbase1.field_76748_D;
                        float f4 = biomegenbase1.field_76749_E;
                        if (this.amplified && f3 > 0.0f) {
                            f3 = 1.0f + f3 * 2.0f;
                            f4 = 1.0f + f4 * 4.0f;
                        }
                        float f5 = this.parabolicField[l1 + 2 + (i2 + 2) * 5] / (f3 + 2.0f);
                        if (biomegenbase1.field_76748_D > biomegenbase.field_76748_D) {
                            f5 /= 2.0f;
                        }
                        f += f4 * f5;
                        f1 += f3 * f5;
                        f2 += f5;
                    }
                }
                f /= f2;
                f1 /= f2;
                f = f * 0.9f + 0.1f;
                f1 = (f1 * 4.0f - 1.0f) / 8.0f;
                double d12 = this.heightOrderBuffer[i1] / 8000.0;
                if (d12 < 0.0) {
                    d12 = -d12 * 0.3;
                }
                if ((d12 = d12 * 3.0 - 2.0) < 0.0) {
                    if ((d12 /= 2.0) < -1.0) {
                        d12 = -1.0;
                    }
                    d12 /= 1.4;
                    d12 /= 2.0;
                } else {
                    if (d12 > 1.0) {
                        d12 = 1.0;
                    }
                    d12 /= 8.0;
                }
                ++i1;
                double d13 = f1;
                double d14 = f;
                d13 += d12 * 0.2;
                d13 = d13 * 8.5 / 8.0;
                double d5 = 8.5 + d13 * 4.0;
                for (int j2 = 0; j2 < 33; ++j2) {
                    double d10;
                    double d6 = ((double)j2 - d5) * 12.0 * 128.0 / 256.0 / d14;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.firstOrderBuffer[l] / 512.0;
                    double d8 = this.secondOrderBuffer[l] / 512.0;
                    double d9 = (this.thirdOrderBuffer[l] / 10.0 + 1.0) / 2.0;
                    double d = d10 = this.reclamp ? MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6 : d8 - d6;
                    if (j2 > 29) {
                        double d11 = (float)(j2 - 29) / 3.0f;
                        d10 = d10 * (1.0 - d11) + -10.0 * d11;
                    }
                    this.terrainBuffer[l] = d10;
                    ++l;
                }
            }
        }
    }

    protected void replaceBlocksForBiome(int x, int z, Block[] blocks, byte[] metas, BiomeGenBase[] biomes) {
        double d0 = 0.03125;
        this.stoneNoise = this.perlin.func_151599_a(this.stoneNoise, (double)(x * 16), (double)(z * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                BiomeGenBase biomegenbase = biomes[l + k * 16];
                biomegenbase.func_150573_a(this.worldObj, this.rand, blocks, metas, x * 16 + k, z * 16 + l, this.stoneNoise[l + k * 16]);
            }
        }
    }

    public boolean func_73149_a(int x, int z) {
        return true;
    }

    public Chunk func_73154_d(int x, int z) {
        BlockFalling.field_149832_M = true;
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        BlockMetaBuffer ablock = this.getChunkPrimer(x, z);
        Chunk chunk = new Chunk(this.worldObj, ablock.blocks, ablock.metas, x, z);
        if (Loader.isModLoaded((String)"endlessids")) {
            short[] biomes = WorldUtil.getBiomeShortArray(chunk);
            for (int k = 0; k < biomes.length; ++k) {
                biomes[k] = (short)this.biomesForGeneration[k].field_76756_M;
            }
        } else {
            byte[] biomes = chunk.func_76605_m();
            for (int k = 0; k < biomes.length; ++k) {
                biomes[k] = (byte)this.biomesForGeneration[k].field_76756_M;
            }
        }
        chunk.func_76603_b();
        BlockFalling.field_149832_M = false;
        return chunk;
    }

    public Chunk func_73158_c(int x, int z) {
        return this.func_73154_d(x, z);
    }

    public void func_73153_a(IChunkProvider provider, int x, int z) {
        BlockFalling.field_149832_M = true;
        this.worldObj.field_73011_w.field_76575_d = false;
        int k = x * 16;
        int l = z * 16;
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(k + 16, l + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * i1 + (long)z * j1 ^ this.worldObj.func_72905_C());
        biomegenbase.func_76728_a(this.worldObj, this.rand, k, l);
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biomegenbase, (int)(k + 8), (int)(l + 8), (int)16, (int)16, (Random)this.rand);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_73151_a(boolean combined, IProgressUpdate progress) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType creatureType, int x, int y, int z) {
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(x, z);
        if (biomegenbase instanceof BiomeGenCraterBase) {
            return new ArrayList();
        }
        return biomegenbase.func_76747_a(creatureType);
    }

    public ChunkPosition func_147416_a(World world, String shitfuck, int x, int y, int z) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int x, int z) {
    }

    public void func_104112_b() {
    }

    public static class BlockMetaBuffer {
        public Block[] blocks = new Block[65536];
        public byte[] metas = new byte[65536];
    }
}

