/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.generic.BlockSkeletonHolder;
import com.hbm.entity.mob.EntityUndeadSoldier;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.util.EnumUtil;
import com.hbm.util.Vec3NT;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class DungeonSpawner
extends BlockContainer {
    public static Function<TileEntityDungeonSpawner, Boolean> CON_ABERRATOR = tile -> {
        World world = tile.func_145831_w();
        if (world.field_73013_u.ordinal() == 0) {
            return false;
        }
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        if (tile.phase == 0) {
            if (world.func_82737_E() % 20L != 0L) {
                return false;
            }
            return !world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y - 2), (double)(z + 1)).func_72314_b(20.0, 10.0, 20.0)).isEmpty();
        }
        if (tile.phase < 3) {
            if (world.func_82737_E() % 20L != 0L || tile.timer < 60) {
                return false;
            }
            return world.func_72872_a(EntityUndeadSoldier.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x - 2), (double)(y + 1), (double)(z + 1)).func_72314_b(50.0, 20.0, 50.0)).isEmpty();
        }
        return false;
    };
    public static Consumer<TileEntityDungeonSpawner> PHASE_ABERRATOR = tile -> {
        World world = tile.func_145831_w();
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        if ((tile.phase == 1 || tile.phase == 2) && tile.timer == 0) {
            Vec3NT vec = new Vec3NT(10.0, 0.0, 0.0);
            for (int i = 0; i < 10; ++i) {
                EntityUndeadSoldier mob = new EntityUndeadSoldier(world);
                for (int j = 0; j < 7; ++j) {
                    mob.func_70080_a((double)x + 0.5 + vec.field_72450_a, y - 5, (double)z + 0.5 + vec.field_72449_c, (float)i * 36.0f, 0.0f);
                    if (!mob.func_70601_bi()) continue;
                    mob.func_110161_a(null);
                    world.func_72838_d((Entity)mob);
                    break;
                }
                vec.rotateAroundYDeg(36.0);
            }
        }
        if (tile.phase > 2) {
            TileEntity te = world.func_147438_o(x, y + 18, z);
            if (te instanceof BlockSkeletonHolder.TileEntitySkeletonHolder) {
                BlockSkeletonHolder.TileEntitySkeletonHolder skeleton = (BlockSkeletonHolder.TileEntitySkeletonHolder)te;
                skeleton.item = world.field_73012_v.nextInt(5) == 0 ? new ItemStack(ModItems.item_secret, 1, ItemEnums.EnumSecretType.ABERRATOR.ordinal()) : new ItemStack(ModItems.clay_tablet, 1, 1);
                skeleton.func_70296_d();
                world.func_147471_g(x, y + 18, z);
            }
            world.func_147449_b(x, y, z, Blocks.field_150343_Z);
        }
    };

    public DungeonSpawner() {
        super(Material.field_151576_e);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDungeonSpawner();
    }

    public static enum EnumSpawnerType {
        ABERRATOR(CON_ABERRATOR, PHASE_ABERRATOR);

        public Function<TileEntityDungeonSpawner, Boolean> phaseCondition;
        public Consumer<TileEntityDungeonSpawner> phase;

        private EnumSpawnerType(Function<TileEntityDungeonSpawner, Boolean> con, Consumer<TileEntityDungeonSpawner> ph) {
            this.phaseCondition = con;
            this.phase = ph;
        }
    }

    public static class TileEntityDungeonSpawner
    extends TileEntity {
        public int phase = 0;
        public int timer = 0;
        public EnumSpawnerType type = EnumSpawnerType.ABERRATOR;

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                this.type.phase.accept(this);
                if (this.type.phaseCondition.apply(this).booleanValue()) {
                    ++this.phase;
                    this.timer = 0;
                } else {
                    ++this.timer;
                }
            }
        }

        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74768_a("phase", this.phase);
            nbt.func_74774_a("type", (byte)this.type.ordinal());
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.phase = nbt.func_74762_e("phase");
            this.type = (EnumSpawnerType)((Object)EnumUtil.grabEnumSafely(EnumSpawnerType.class, nbt.func_74771_c("type")));
        }
    }
}

