/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class UpgradeInventory
extends AppEngInternalInventory
implements IAEAppEngInventory {
    private final IAEAppEngInventory parent;
    private boolean cached = false;
    private int fuzzyUpgrades = 0;
    private int speedUpgrades = 0;
    private int redstoneUpgrades = 0;
    private int capacityUpgrades = 0;
    private int inverterUpgrades = 0;
    private int craftingUpgrades = 0;

    public UpgradeInventory(IAEAppEngInventory parent, int s) {
        super(null, s);
        this.te = this;
        this.parent = parent;
    }

    @Override
    protected boolean eventsEnabled() {
        return true;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        Upgrades u;
        if (itemstack == null) {
            return false;
        }
        Item it = itemstack.func_77973_b();
        if (it instanceof IUpgradeModule && (u = ((IUpgradeModule)it).getType(itemstack)) != null) {
            return this.getInstalledUpgrades(u) < this.getMaxInstalled(u);
        }
        return false;
    }

    public int getInstalledUpgrades(Upgrades u) {
        if (!this.cached) {
            this.updateUpgradeInfo();
        }
        switch (u) {
            case CAPACITY: {
                return this.capacityUpgrades;
            }
            case FUZZY: {
                return this.fuzzyUpgrades;
            }
            case REDSTONE: {
                return this.redstoneUpgrades;
            }
            case SPEED: {
                return this.speedUpgrades;
            }
            case INVERTER: {
                return this.inverterUpgrades;
            }
            case CRAFTING: {
                return this.craftingUpgrades;
            }
        }
        return 0;
    }

    public abstract int getMaxInstalled(Upgrades var1);

    private void updateUpgradeInfo() {
        this.cached = true;
        this.craftingUpgrades = 0;
        this.fuzzyUpgrades = 0;
        this.speedUpgrades = 0;
        this.redstoneUpgrades = 0;
        this.capacityUpgrades = 0;
        this.inverterUpgrades = 0;
        for (ItemStack is : this) {
            if (is == null || is.func_77973_b() == null || !(is.func_77973_b() instanceof IUpgradeModule)) continue;
            Upgrades myUpgrade = ((IUpgradeModule)is.func_77973_b()).getType(is);
            switch (myUpgrade) {
                case CAPACITY: {
                    ++this.capacityUpgrades;
                    break;
                }
                case FUZZY: {
                    ++this.fuzzyUpgrades;
                    break;
                }
                case REDSTONE: {
                    ++this.redstoneUpgrades;
                    break;
                }
                case SPEED: {
                    ++this.speedUpgrades;
                    break;
                }
                case INVERTER: {
                    ++this.inverterUpgrades;
                    break;
                }
                case CRAFTING: {
                    ++this.craftingUpgrades;
                    break;
                }
            }
        }
        this.capacityUpgrades = Math.min(this.capacityUpgrades, this.getMaxInstalled(Upgrades.CAPACITY));
        this.fuzzyUpgrades = Math.min(this.fuzzyUpgrades, this.getMaxInstalled(Upgrades.FUZZY));
        this.redstoneUpgrades = Math.min(this.redstoneUpgrades, this.getMaxInstalled(Upgrades.REDSTONE));
        this.speedUpgrades = Math.min(this.speedUpgrades, this.getMaxInstalled(Upgrades.SPEED));
        this.inverterUpgrades = Math.min(this.inverterUpgrades, this.getMaxInstalled(Upgrades.INVERTER));
        this.craftingUpgrades = Math.min(this.craftingUpgrades, this.getMaxInstalled(Upgrades.CRAFTING));
    }

    @Override
    public void readFromNBT(NBTTagCompound target) {
        super.readFromNBT(target);
        this.updateUpgradeInfo();
    }

    @Override
    public void saveChanges() {
        this.parent.saveChanges();
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.cached = false;
        if (this.parent != null && Platform.isServer()) {
            this.parent.onChangeInventory(inv, slot, mc, removedStack, newStack);
        }
    }
}

